<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y/M/d',
            'time' => 'H:mm',
            'datetime' => 'y/M/d H:mm',
        ],
        'medium' => [
            'date' => 'y/M/d',
            'time' => 'H:mm:ss',
            'datetime' => 'y/M/d H:mm:ss',
        ],
        'long' => [
            'date' => 'y年M月d日',
            'time' => 'H:mm:ss z',
            'datetime' => 'y年M月d日 H:mm:ss z',
        ],
        'full' => [
            'date' => 'y年M月d日EEEE',
            'time' => 'H時mm分ss秒 zzzz',
            'datetime' => 'y年M月d日EEEE H時mm分ss秒 zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => '午前',
    'pmName' => '午後',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => '元',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '￥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'short' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'medium' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'full' => [
            '日曜日',
            '月曜日',
            '火曜日',
            '水曜日',
            '木曜日',
            '金曜日',
            '土曜日',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'short' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'medium' => [
            '日',
            '月',
            '火',
            '水',
            '木',
            '金',
            '土',
        ],
        'full' => [
            '日曜日',
            '月曜日',
            '火曜日',
            '水曜日',
            '木曜日',
            '金曜日',
            '土曜日',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'アフリカーンス語',
        'af-NA' => 'アフリカーンス語 (ナミビア)',
        'af-ZA' => 'アフリカーンス語 (南アフリカ)',
        'agq' => 'アゲム語',
        'agq-CM' => 'アゲム語 (カメルーン)',
        'ak' => 'アカン語',
        'ak-GH' => 'アカン語 (ガーナ)',
        'am' => 'アムハラ語',
        'am-ET' => 'アムハラ語 (エチオピア)',
        'ar' => 'アラビア語',
        'ar-001' => 'アラビア語 (世界)',
        'ar-AE' => 'アラビア語 (アラブ首長国連邦)',
        'ar-BH' => 'アラビア語 (バーレーン)',
        'ar-DJ' => 'アラビア語 (ジブチ)',
        'ar-DZ' => 'アラビア語 (アルジェリア)',
        'ar-EG' => 'アラビア語 (エジプト)',
        'ar-EH' => 'アラビア語 (西サハラ)',
        'ar-ER' => 'アラビア語 (エリトリア)',
        'ar-IL' => 'アラビア語 (イスラエル)',
        'ar-IQ' => 'アラビア語 (イラク)',
        'ar-JO' => 'アラビア語 (ヨルダン)',
        'ar-KM' => 'アラビア語 (コモロ)',
        'ar-KW' => 'アラビア語 (クウェート)',
        'ar-LB' => 'アラビア語 (レバノン)',
        'ar-LY' => 'アラビア語 (リビア)',
        'ar-MA' => 'アラビア語 (モロッコ)',
        'ar-MR' => 'アラビア語 (モーリタニア)',
        'ar-OM' => 'アラビア語 (オマーン)',
        'ar-PS' => 'アラビア語 (パレスチナ)',
        'ar-QA' => 'アラビア語 (カタール)',
        'ar-SA' => 'アラビア語 (サウジアラビア)',
        'ar-SD' => 'アラビア語 (スーダン)',
        'ar-SO' => 'アラビア語 (ソマリア)',
        'ar-SS' => 'アラビア語 (南スーダン)',
        'ar-SY' => 'アラビア語 (シリア)',
        'ar-TD' => 'アラビア語 (チャド)',
        'ar-TN' => 'アラビア語 (チュニジア)',
        'ar-YE' => 'アラビア語 (イエメン)',
        'as' => 'アッサム語',
        'as-IN' => 'アッサム語 (インド)',
        'asa' => 'アス語',
        'asa-TZ' => 'アス語 (タンザニア)',
        'ast' => 'アストゥリアス語',
        'ast-ES' => 'アストゥリアス語 (スペイン)',
        'az' => 'アゼルバイジャン語',
        'az-Cyrl' => 'アゼルバイジャン語 (キリル文字)',
        'az-Cyrl-AZ' => 'アゼルバイジャン語 (キリル文字、アゼルバイジャン)',
        'az-Latn' => 'アゼルバイジャン語 (ラテン文字)',
        'az-Latn-AZ' => 'アゼルバイジャン語 (ラテン文字、アゼルバイジャン)',
        'bas' => 'バサ語',
        'bas-CM' => 'バサ語 (カメルーン)',
        'be' => 'ベラルーシ語',
        'be-BY' => 'ベラルーシ語 (ベラルーシ)',
        'bem' => 'ベンバ語',
        'bem-ZM' => 'ベンバ語 (ザンビア)',
        'bez' => 'ベナ語',
        'bez-TZ' => 'ベナ語 (タンザニア)',
        'bg' => 'ブルガリア語',
        'bg-BG' => 'ブルガリア語 (ブルガリア)',
        'bm' => 'バンバラ語',
        'bm-ML' => 'バンバラ語 (マリ)',
        'bn' => 'ベンガル語',
        'bn-BD' => 'ベンガル語 (バングラデシュ)',
        'bn-IN' => 'ベンガル語 (インド)',
        'bo' => 'チベット語',
        'bo-CN' => 'チベット語 (中国)',
        'bo-IN' => 'チベット語 (インド)',
        'br' => 'ブルトン語',
        'br-FR' => 'ブルトン語 (フランス)',
        'brx' => 'ボド語',
        'brx-IN' => 'ボド語 (インド)',
        'bs' => 'ボスニア語',
        'bs-Cyrl' => 'ボスニア語 (キリル文字)',
        'bs-Cyrl-BA' => 'ボスニア語 (キリル文字、ボスニア・ヘルツェゴビナ)',
        'bs-Latn' => 'ボスニア語 (ラテン文字)',
        'bs-Latn-BA' => 'ボスニア語 (ラテン文字、ボスニア・ヘルツェゴビナ)',
        'ca' => 'カタロニア語',
        'ca-AD' => 'カタロニア語 (アンドラ)',
        'ca-ES' => 'カタロニア語 (スペイン)',
        'ca-FR' => 'カタロニア語 (フランス)',
        'ca-IT' => 'カタロニア語 (イタリア)',
        'ce' => 'チェチェン語',
        'ce-RU' => 'チェチェン語 (ロシア)',
        'cgg' => 'チガ語',
        'cgg-UG' => 'チガ語 (ウガンダ)',
        'chr' => 'チェロキー語',
        'chr-US' => 'チェロキー語 (アメリカ合衆国)',
        'cs' => 'チェコ語',
        'cs-CZ' => 'チェコ語 (チェコ共和国)',
        'cy' => 'ウェールズ語',
        'cy-GB' => 'ウェールズ語 (イギリス)',
        'da' => 'デンマーク語',
        'da-DK' => 'デンマーク語 (デンマーク)',
        'da-GL' => 'デンマーク語 (グリーンランド)',
        'dav' => 'タイタ語',
        'dav-KE' => 'タイタ語 (ケニア)',
        'de' => 'ドイツ語',
        'de-AT' => 'ドイツ語 (オーストリア)',
        'de-BE' => 'ドイツ語 (ベルギー)',
        'de-CH' => 'ドイツ語 (スイス)',
        'de-DE' => 'ドイツ語 (ドイツ)',
        'de-LI' => 'ドイツ語 (リヒテンシュタイン)',
        'de-LU' => 'ドイツ語 (ルクセンブルグ)',
        'dje' => 'ザルマ語',
        'dje-NE' => 'ザルマ語 (ニジェール)',
        'dsb' => '低ソルビア語',
        'dsb-DE' => '低ソルビア語 (ドイツ)',
        'dua' => 'ドゥアラ語',
        'dua-CM' => 'ドゥアラ語 (カメルーン)',
        'dyo' => 'ジョラ＝フォニィ語',
        'dyo-SN' => 'ジョラ＝フォニィ語 (セネガル)',
        'dz' => 'ゾンカ語',
        'dz-BT' => 'ゾンカ語 (ブータン)',
        'ebu' => 'エンブ語',
        'ebu-KE' => 'エンブ語 (ケニア)',
        'ee' => 'エウェ語',
        'ee-GH' => 'エウェ語 (ガーナ)',
        'ee-TG' => 'エウェ語 (トーゴ)',
        'el' => 'ギリシャ語',
        'el-CY' => 'ギリシャ語 (キプロス)',
        'el-GR' => 'ギリシャ語 (ギリシャ)',
        'en' => '英語',
        'en-001' => '英語 (世界)',
        'en-150' => '英語 (ヨーロッパ)',
        'en-AG' => '英語 (アンティグア・バーブーダ)',
        'en-AI' => '英語 (アンギラ)',
        'en-AS' => '英語 (米領サモア)',
        'en-AT' => '英語 (オーストリア)',
        'en-AU' => '英語 (オーストラリア)',
        'en-BB' => '英語 (バルバドス)',
        'en-BE' => '英語 (ベルギー)',
        'en-BI' => '英語 (ブルンジ)',
        'en-BM' => '英語 (バミューダ)',
        'en-BS' => '英語 (バハマ)',
        'en-BW' => '英語 (ボツワナ)',
        'en-BZ' => '英語 (ベリーズ)',
        'en-CA' => '英語 (カナダ)',
        'en-CC' => '英語 (ココス[キーリング]諸島)',
        'en-CH' => '英語 (スイス)',
        'en-CK' => '英語 (クック諸島)',
        'en-CM' => '英語 (カメルーン)',
        'en-CX' => '英語 (クリスマス島)',
        'en-CY' => '英語 (キプロス)',
        'en-DE' => '英語 (ドイツ)',
        'en-DG' => '英語 (ディエゴガルシア島)',
        'en-DK' => '英語 (デンマーク)',
        'en-DM' => '英語 (ドミニカ国)',
        'en-ER' => '英語 (エリトリア)',
        'en-FI' => '英語 (フィンランド)',
        'en-FJ' => '英語 (フィジー)',
        'en-FK' => '英語 (フォークランド諸島)',
        'en-FM' => '英語 (ミクロネシア連邦)',
        'en-GB' => '英語 (イギリス)',
        'en-GD' => '英語 (グレナダ)',
        'en-GG' => '英語 (ガーンジー)',
        'en-GH' => '英語 (ガーナ)',
        'en-GI' => '英語 (ジブラルタル)',
        'en-GM' => '英語 (ガンビア)',
        'en-GU' => '英語 (グアム)',
        'en-GY' => '英語 (ガイアナ)',
        'en-HK' => '英語 (中華人民共和国香港特別行政区)',
        'en-IE' => '英語 (アイルランド)',
        'en-IL' => '英語 (イスラエル)',
        'en-IM' => '英語 (マン島)',
        'en-IN' => '英語 (インド)',
        'en-IO' => '英語 (英領インド洋地域)',
        'en-JE' => '英語 (ジャージー)',
        'en-JM' => '英語 (ジャマイカ)',
        'en-KE' => '英語 (ケニア)',
        'en-KI' => '英語 (キリバス)',
        'en-KN' => '英語 (セントクリストファー・ネイビス)',
        'en-KY' => '英語 (ケイマン諸島)',
        'en-LC' => '英語 (セントルシア)',
        'en-LR' => '英語 (リベリア)',
        'en-LS' => '英語 (レソト)',
        'en-MG' => '英語 (マダガスカル)',
        'en-MH' => '英語 (マーシャル諸島)',
        'en-MO' => '英語 (中華人民共和国マカオ特別行政区)',
        'en-MP' => '英語 (北マリアナ諸島)',
        'en-MS' => '英語 (モントセラト)',
        'en-MT' => '英語 (マルタ)',
        'en-MU' => '英語 (モーリシャス)',
        'en-MW' => '英語 (マラウイ)',
        'en-MY' => '英語 (マレーシア)',
        'en-NA' => '英語 (ナミビア)',
        'en-NF' => '英語 (ノーフォーク島)',
        'en-NG' => '英語 (ナイジェリア)',
        'en-NL' => '英語 (オランダ)',
        'en-NR' => '英語 (ナウル)',
        'en-NU' => '英語 (ニウエ島)',
        'en-NZ' => '英語 (ニュージーランド)',
        'en-PG' => '英語 (パプアニューギニア)',
        'en-PH' => '英語 (フィリピン)',
        'en-PK' => '英語 (パキスタン)',
        'en-PN' => '英語 (ピトケアン諸島)',
        'en-PR' => '英語 (プエルトリコ)',
        'en-PW' => '英語 (パラオ)',
        'en-RW' => '英語 (ルワンダ)',
        'en-SB' => '英語 (ソロモン諸島)',
        'en-SC' => '英語 (セーシェル)',
        'en-SD' => '英語 (スーダン)',
        'en-SE' => '英語 (スウェーデン)',
        'en-SG' => '英語 (シンガポール)',
        'en-SH' => '英語 (セントヘレナ)',
        'en-SI' => '英語 (スロベニア)',
        'en-SL' => '英語 (シエラレオネ)',
        'en-SS' => '英語 (南スーダン)',
        'en-SX' => '英語 (シント・マールテン)',
        'en-SZ' => '英語 (スワジランド)',
        'en-TC' => '英語 (タークス・カイコス諸島)',
        'en-TK' => '英語 (トケラウ)',
        'en-TO' => '英語 (トンガ)',
        'en-TT' => '英語 (トリニダード・トバゴ)',
        'en-TV' => '英語 (ツバル)',
        'en-TZ' => '英語 (タンザニア)',
        'en-UG' => '英語 (ウガンダ)',
        'en-UM' => '英語 (米領太平洋諸島)',
        'en-US' => '英語 (アメリカ合衆国)',
        'en-US-POSIX' => '英語 (アメリカ合衆国、コンピュータ)',
        'en-VC' => '英語 (セントビンセント・グレナディーン諸島)',
        'en-VG' => '英語 (英領ヴァージン諸島)',
        'en-VI' => '英語 (米領ヴァージン諸島)',
        'en-VU' => '英語 (バヌアツ)',
        'en-WS' => '英語 (サモア)',
        'en-ZA' => '英語 (南アフリカ)',
        'en-ZM' => '英語 (ザンビア)',
        'en-ZW' => '英語 (ジンバブエ)',
        'eo' => 'エスペラント語',
        'es' => 'スペイン語',
        'es-419' => 'スペイン語 (ラテンアメリカ)',
        'es-AR' => 'スペイン語 (アルゼンチン)',
        'es-BO' => 'スペイン語 (ボリビア)',
        'es-CL' => 'スペイン語 (チリ)',
        'es-CO' => 'スペイン語 (コロンビア)',
        'es-CR' => 'スペイン語 (コスタリカ)',
        'es-CU' => 'スペイン語 (キューバ)',
        'es-DO' => 'スペイン語 (ドミニカ共和国)',
        'es-EA' => 'スペイン語 (セウタ・メリリャ)',
        'es-EC' => 'スペイン語 (エクアドル)',
        'es-ES' => 'スペイン語 (スペイン)',
        'es-GQ' => 'スペイン語 (赤道ギニア)',
        'es-GT' => 'スペイン語 (グアテマラ)',
        'es-HN' => 'スペイン語 (ホンジュラス)',
        'es-IC' => 'スペイン語 (カナリア諸島)',
        'es-MX' => 'スペイン語 (メキシコ)',
        'es-NI' => 'スペイン語 (ニカラグア)',
        'es-PA' => 'スペイン語 (パナマ)',
        'es-PE' => 'スペイン語 (ペルー)',
        'es-PH' => 'スペイン語 (フィリピン)',
        'es-PR' => 'スペイン語 (プエルトリコ)',
        'es-PY' => 'スペイン語 (パラグアイ)',
        'es-SV' => 'スペイン語 (エルサルバドル)',
        'es-US' => 'スペイン語 (アメリカ合衆国)',
        'es-UY' => 'スペイン語 (ウルグアイ)',
        'es-VE' => 'スペイン語 (ベネズエラ)',
        'et' => 'エストニア語',
        'et-EE' => 'エストニア語 (エストニア)',
        'eu' => 'バスク語',
        'eu-ES' => 'バスク語 (スペイン)',
        'ewo' => 'エウォンド語',
        'ewo-CM' => 'エウォンド語 (カメルーン)',
        'fa' => 'ペルシア語',
        'fa-AF' => 'ペルシア語 (アフガニスタン)',
        'fa-IR' => 'ペルシア語 (イラン)',
        'ff' => 'フラニ語',
        'ff-CM' => 'フラニ語 (カメルーン)',
        'ff-GN' => 'フラニ語 (ギニア)',
        'ff-MR' => 'フラニ語 (モーリタニア)',
        'ff-SN' => 'フラニ語 (セネガル)',
        'fi' => 'フィンランド語',
        'fi-FI' => 'フィンランド語 (フィンランド)',
        'fil' => 'フィリピノ語',
        'fil-PH' => 'フィリピノ語 (フィリピン)',
        'fo' => 'フェロー語',
        'fo-DK' => 'フェロー語 (デンマーク)',
        'fo-FO' => 'フェロー語 (フェロー諸島)',
        'fr' => 'フランス語',
        'fr-BE' => 'フランス語 (ベルギー)',
        'fr-BF' => 'フランス語 (ブルキナファソ)',
        'fr-BI' => 'フランス語 (ブルンジ)',
        'fr-BJ' => 'フランス語 (ベナン)',
        'fr-BL' => 'フランス語 (サン・バルテルミー島)',
        'fr-CA' => 'フランス語 (カナダ)',
        'fr-CD' => 'フランス語 (コンゴ民主共和国[キンシャサ])',
        'fr-CF' => 'フランス語 (中央アフリカ共和国)',
        'fr-CG' => 'フランス語 (コンゴ共和国[ブラザビル])',
        'fr-CH' => 'フランス語 (スイス)',
        'fr-CI' => 'フランス語 (コートジボワール)',
        'fr-CM' => 'フランス語 (カメルーン)',
        'fr-DJ' => 'フランス語 (ジブチ)',
        'fr-DZ' => 'フランス語 (アルジェリア)',
        'fr-FR' => 'フランス語 (フランス)',
        'fr-GA' => 'フランス語 (ガボン)',
        'fr-GF' => 'フランス語 (仏領ギアナ)',
        'fr-GN' => 'フランス語 (ギニア)',
        'fr-GP' => 'フランス語 (グアドループ)',
        'fr-GQ' => 'フランス語 (赤道ギニア)',
        'fr-HT' => 'フランス語 (ハイチ)',
        'fr-KM' => 'フランス語 (コモロ)',
        'fr-LU' => 'フランス語 (ルクセンブルグ)',
        'fr-MA' => 'フランス語 (モロッコ)',
        'fr-MC' => 'フランス語 (モナコ)',
        'fr-MF' => 'フランス語 (サン・マルタン)',
        'fr-MG' => 'フランス語 (マダガスカル)',
        'fr-ML' => 'フランス語 (マリ)',
        'fr-MQ' => 'フランス語 (マルティニーク)',
        'fr-MR' => 'フランス語 (モーリタニア)',
        'fr-MU' => 'フランス語 (モーリシャス)',
        'fr-NC' => 'フランス語 (ニューカレドニア)',
        'fr-NE' => 'フランス語 (ニジェール)',
        'fr-PF' => 'フランス語 (仏領ポリネシア)',
        'fr-PM' => 'フランス語 (サンピエール島・ミクロン島)',
        'fr-RE' => 'フランス語 (レユニオン島)',
        'fr-RW' => 'フランス語 (ルワンダ)',
        'fr-SC' => 'フランス語 (セーシェル)',
        'fr-SN' => 'フランス語 (セネガル)',
        'fr-SY' => 'フランス語 (シリア)',
        'fr-TD' => 'フランス語 (チャド)',
        'fr-TG' => 'フランス語 (トーゴ)',
        'fr-TN' => 'フランス語 (チュニジア)',
        'fr-VU' => 'フランス語 (バヌアツ)',
        'fr-WF' => 'フランス語 (ウォリス・フツナ)',
        'fr-YT' => 'フランス語 (マヨット島)',
        'fur' => 'フリウリ語',
        'fur-IT' => 'フリウリ語 (イタリア)',
        'fy' => '西フリジア語',
        'fy-NL' => '西フリジア語 (オランダ)',
        'ga' => 'アイルランド語',
        'ga-IE' => 'アイルランド語 (アイルランド)',
        'gd' => 'スコットランド・ゲール語',
        'gd-GB' => 'スコットランド・ゲール語 (イギリス)',
        'gl' => 'ガリシア語',
        'gl-ES' => 'ガリシア語 (スペイン)',
        'gsw' => 'スイスドイツ語',
        'gsw-CH' => 'スイスドイツ語 (スイス)',
        'gsw-FR' => 'スイスドイツ語 (フランス)',
        'gsw-LI' => 'スイスドイツ語 (リヒテンシュタイン)',
        'gu' => 'グジャラート語',
        'gu-IN' => 'グジャラート語 (インド)',
        'guz' => 'グシイ語',
        'guz-KE' => 'グシイ語 (ケニア)',
        'gv' => 'マン島語',
        'gv-IM' => 'マン島語 (マン島)',
        'ha' => 'ハウサ語',
        'ha-GH' => 'ハウサ語 (ガーナ)',
        'ha-NE' => 'ハウサ語 (ニジェール)',
        'ha-NG' => 'ハウサ語 (ナイジェリア)',
        'haw' => 'ハワイ語',
        'haw-US' => 'ハワイ語 (アメリカ合衆国)',
        'he' => 'ヘブライ語',
        'he-IL' => 'ヘブライ語 (イスラエル)',
        'hi' => 'ヒンディー語',
        'hi-IN' => 'ヒンディー語 (インド)',
        'hr' => 'クロアチア語',
        'hr-BA' => 'クロアチア語 (ボスニア・ヘルツェゴビナ)',
        'hr-HR' => 'クロアチア語 (クロアチア)',
        'hsb' => '上ソルビア語',
        'hsb-DE' => '上ソルビア語 (ドイツ)',
        'hu' => 'ハンガリー語',
        'hu-HU' => 'ハンガリー語 (ハンガリー)',
        'hy' => 'アルメニア語',
        'hy-AM' => 'アルメニア語 (アルメニア)',
        'id' => 'インドネシア語',
        'id-ID' => 'インドネシア語 (インドネシア)',
        'ig' => 'イボ語',
        'ig-NG' => 'イボ語 (ナイジェリア)',
        'ii' => '四川イ語',
        'ii-CN' => '四川イ語 (中国)',
        'is' => 'アイスランド語',
        'is-IS' => 'アイスランド語 (アイスランド)',
        'it' => 'イタリア語',
        'it-CH' => 'イタリア語 (スイス)',
        'it-IT' => 'イタリア語 (イタリア)',
        'it-SM' => 'イタリア語 (サンマリノ)',
        'ja' => '日本語',
        'ja-JP' => '日本語 (日本)',
        'jgo' => 'ンゴンバ語',
        'jgo-CM' => 'ンゴンバ語 (カメルーン)',
        'jmc' => 'マチャメ語',
        'jmc-TZ' => 'マチャメ語 (タンザニア)',
        'ka' => 'ジョージア語',
        'ka-GE' => 'ジョージア語 (ジョージア)',
        'kab' => 'カビル語',
        'kab-DZ' => 'カビル語 (アルジェリア)',
        'kam' => 'カンバ語',
        'kam-KE' => 'カンバ語 (ケニア)',
        'kde' => 'マコンデ語',
        'kde-TZ' => 'マコンデ語 (タンザニア)',
        'kea' => 'カーボベルデ・クレオール語',
        'kea-CV' => 'カーボベルデ・クレオール語 (カーボベルデ)',
        'khq' => 'コイラ・チーニ語',
        'khq-ML' => 'コイラ・チーニ語 (マリ)',
        'ki' => 'キクユ語',
        'ki-KE' => 'キクユ語 (ケニア)',
        'kk' => 'カザフ語',
        'kk-KZ' => 'カザフ語 (カザフスタン)',
        'kkj' => 'カコ語',
        'kkj-CM' => 'カコ語 (カメルーン)',
        'kl' => 'グリーンランド語',
        'kl-GL' => 'グリーンランド語 (グリーンランド)',
        'kln' => 'カレンジン語',
        'kln-KE' => 'カレンジン語 (ケニア)',
        'km' => 'クメール語',
        'km-KH' => 'クメール語 (カンボジア)',
        'kn' => 'カンナダ語',
        'kn-IN' => 'カンナダ語 (インド)',
        'ko' => '韓国語',
        'ko-KP' => '韓国語 (朝鮮民主主義人民共和国)',
        'ko-KR' => '韓国語 (大韓民国)',
        'kok' => 'コンカニ語',
        'kok-IN' => 'コンカニ語 (インド)',
        'ks' => 'カシミール語',
        'ks-IN' => 'カシミール語 (インド)',
        'ksb' => 'サンバー語',
        'ksb-TZ' => 'サンバー語 (タンザニア)',
        'ksf' => 'バフィア語',
        'ksf-CM' => 'バフィア語 (カメルーン)',
        'ksh' => 'ケルン語',
        'ksh-DE' => 'ケルン語 (ドイツ)',
        'kw' => 'コーンウォール語',
        'kw-GB' => 'コーンウォール語 (イギリス)',
        'ky' => 'キルギス語',
        'ky-KG' => 'キルギス語 (キルギス)',
        'lag' => 'ランギ語',
        'lag-TZ' => 'ランギ語 (タンザニア)',
        'lb' => 'ルクセンブルク語',
        'lb-LU' => 'ルクセンブルク語 (ルクセンブルグ)',
        'lg' => 'ガンダ語',
        'lg-UG' => 'ガンダ語 (ウガンダ)',
        'lkt' => 'ラコタ語',
        'lkt-US' => 'ラコタ語 (アメリカ合衆国)',
        'ln' => 'リンガラ語',
        'ln-AO' => 'リンガラ語 (アンゴラ)',
        'ln-CD' => 'リンガラ語 (コンゴ民主共和国[キンシャサ])',
        'ln-CF' => 'リンガラ語 (中央アフリカ共和国)',
        'ln-CG' => 'リンガラ語 (コンゴ共和国[ブラザビル])',
        'lo' => 'ラオ語',
        'lo-LA' => 'ラオ語 (ラオス)',
        'lrc' => '北ロル語',
        'lrc-IQ' => '北ロル語 (イラク)',
        'lrc-IR' => '北ロル語 (イラン)',
        'lt' => 'リトアニア語',
        'lt-LT' => 'リトアニア語 (リトアニア)',
        'lu' => 'ルバ・カタンガ語',
        'lu-CD' => 'ルバ・カタンガ語 (コンゴ民主共和国[キンシャサ])',
        'luo' => 'ルオ語',
        'luo-KE' => 'ルオ語 (ケニア)',
        'luy' => 'ルヒヤ語',
        'luy-KE' => 'ルヒヤ語 (ケニア)',
        'lv' => 'ラトビア語',
        'lv-LV' => 'ラトビア語 (ラトビア)',
        'mas' => 'マサイ語',
        'mas-KE' => 'マサイ語 (ケニア)',
        'mas-TZ' => 'マサイ語 (タンザニア)',
        'mer' => 'メル語',
        'mer-KE' => 'メル語 (ケニア)',
        'mfe' => 'モーリシャス・クレオール語',
        'mfe-MU' => 'モーリシャス・クレオール語 (モーリシャス)',
        'mg' => 'マダガスカル語',
        'mg-MG' => 'マダガスカル語 (マダガスカル)',
        'mgh' => 'マクア・ミート語',
        'mgh-MZ' => 'マクア・ミート語 (モザンビーク)',
        'mgo' => 'メタ語',
        'mgo-CM' => 'メタ語 (カメルーン)',
        'mk' => 'マケドニア語',
        'mk-MK' => 'マケドニア語 (マケドニア)',
        'ml' => 'マラヤーラム語',
        'ml-IN' => 'マラヤーラム語 (インド)',
        'mn' => 'モンゴル語',
        'mn-MN' => 'モンゴル語 (モンゴル)',
        'mr' => 'マラーティー語',
        'mr-IN' => 'マラーティー語 (インド)',
        'ms' => 'マレー語',
        'ms-BN' => 'マレー語 (ブルネイ)',
        'ms-MY' => 'マレー語 (マレーシア)',
        'ms-SG' => 'マレー語 (シンガポール)',
        'mt' => 'マルタ語',
        'mt-MT' => 'マルタ語 (マルタ)',
        'mua' => 'ムンダン語',
        'mua-CM' => 'ムンダン語 (カメルーン)',
        'my' => 'ビルマ語',
        'my-MM' => 'ビルマ語 (ミャンマー)',
        'mzn' => 'マーザンダラーン語',
        'mzn-IR' => 'マーザンダラーン語 (イラン)',
        'naq' => 'ナマ語',
        'naq-NA' => 'ナマ語 (ナミビア)',
        'nb' => 'ノルウェー語(ブークモール)',
        'nb-NO' => 'ノルウェー語(ブークモール) (ノルウェー)',
        'nb-SJ' => 'ノルウェー語(ブークモール) (スバールバル諸島・ヤンマイエン島)',
        'nd' => '北ンデベレ語',
        'nd-ZW' => '北ンデベレ語 (ジンバブエ)',
        'ne' => 'ネパール語',
        'ne-IN' => 'ネパール語 (インド)',
        'ne-NP' => 'ネパール語 (ネパール)',
        'nl' => 'オランダ語',
        'nl-AW' => 'オランダ語 (アルバ)',
        'nl-BE' => 'オランダ語 (ベルギー)',
        'nl-BQ' => 'オランダ語 (オランダ領カリブ)',
        'nl-CW' => 'オランダ語 (キュラソー)',
        'nl-NL' => 'オランダ語 (オランダ)',
        'nl-SR' => 'オランダ語 (スリナム)',
        'nl-SX' => 'オランダ語 (シント・マールテン)',
        'nmg' => 'クワシオ語',
        'nmg-CM' => 'クワシオ語 (カメルーン)',
        'nn' => 'ノルウェー語(ニーノシュク)',
        'nn-NO' => 'ノルウェー語(ニーノシュク) (ノルウェー)',
        'nnh' => 'ンジエムブーン語',
        'nnh-CM' => 'ンジエムブーン語 (カメルーン)',
        'nus' => 'ヌエル語',
        'nus-SS' => 'ヌエル語 (南スーダン)',
        'nyn' => 'ニャンコレ語',
        'nyn-UG' => 'ニャンコレ語 (ウガンダ)',
        'om' => 'オロモ語',
        'om-ET' => 'オロモ語 (エチオピア)',
        'om-KE' => 'オロモ語 (ケニア)',
        'or' => 'オリヤー語',
        'or-IN' => 'オリヤー語 (インド)',
        'os' => 'オセット語',
        'os-GE' => 'オセット語 (ジョージア)',
        'os-RU' => 'オセット語 (ロシア)',
        'pa' => 'パンジャブ語',
        'pa-Arab' => 'パンジャブ語 (アラビア文字)',
        'pa-Arab-PK' => 'パンジャブ語 (アラビア文字、パキスタン)',
        'pa-Guru' => 'パンジャブ語 (グルムキー文字)',
        'pa-Guru-IN' => 'パンジャブ語 (グルムキー文字、インド)',
        'pl' => 'ポーランド語',
        'pl-PL' => 'ポーランド語 (ポーランド)',
        'ps' => 'パシュトゥー語',
        'ps-AF' => 'パシュトゥー語 (アフガニスタン)',
        'pt' => 'ポルトガル語',
        'pt-AO' => 'ポルトガル語 (アンゴラ)',
        'pt-BR' => 'ポルトガル語 (ブラジル)',
        'pt-CV' => 'ポルトガル語 (カーボベルデ)',
        'pt-GW' => 'ポルトガル語 (ギニアビサウ)',
        'pt-MO' => 'ポルトガル語 (中華人民共和国マカオ特別行政区)',
        'pt-MZ' => 'ポルトガル語 (モザンビーク)',
        'pt-PT' => 'ポルトガル語 (ポルトガル)',
        'pt-ST' => 'ポルトガル語 (サントメ・プリンシペ)',
        'pt-TL' => 'ポルトガル語 (東ティモール)',
        'qu' => 'ケチュア語',
        'qu-BO' => 'ケチュア語 (ボリビア)',
        'qu-EC' => 'ケチュア語 (エクアドル)',
        'qu-PE' => 'ケチュア語 (ペルー)',
        'rm' => 'ロマンシュ語',
        'rm-CH' => 'ロマンシュ語 (スイス)',
        'rn' => 'ルンディ語',
        'rn-BI' => 'ルンディ語 (ブルンジ)',
        'ro' => 'ルーマニア語',
        'ro-MD' => 'ルーマニア語 (モルドバ)',
        'ro-RO' => 'ルーマニア語 (ルーマニア)',
        'rof' => 'ロンボ語',
        'rof-TZ' => 'ロンボ語 (タンザニア)',
        'ru' => 'ロシア語',
        'ru-BY' => 'ロシア語 (ベラルーシ)',
        'ru-KG' => 'ロシア語 (キルギス)',
        'ru-KZ' => 'ロシア語 (カザフスタン)',
        'ru-MD' => 'ロシア語 (モルドバ)',
        'ru-RU' => 'ロシア語 (ロシア)',
        'ru-UA' => 'ロシア語 (ウクライナ)',
        'rw' => 'ルワンダ語',
        'rw-RW' => 'ルワンダ語 (ルワンダ)',
        'rwk' => 'ルワ語',
        'rwk-TZ' => 'ルワ語 (タンザニア)',
        'sah' => 'ヤクート語',
        'sah-RU' => 'ヤクート語 (ロシア)',
        'saq' => 'サンブル語',
        'saq-KE' => 'サンブル語 (ケニア)',
        'sbp' => 'サング語',
        'sbp-TZ' => 'サング語 (タンザニア)',
        'se' => '北サーミ語',
        'se-FI' => '北サーミ語 (フィンランド)',
        'se-NO' => '北サーミ語 (ノルウェー)',
        'se-SE' => '北サーミ語 (スウェーデン)',
        'seh' => 'セナ語',
        'seh-MZ' => 'セナ語 (モザンビーク)',
        'ses' => 'コイラボロ・センニ語',
        'ses-ML' => 'コイラボロ・センニ語 (マリ)',
        'sg' => 'サンゴ語',
        'sg-CF' => 'サンゴ語 (中央アフリカ共和国)',
        'shi' => 'タシルハイト語',
        'shi-Latn' => 'タシルハイト語 (ラテン文字)',
        'shi-Latn-MA' => 'タシルハイト語 (ラテン文字、モロッコ)',
        'shi-Tfng' => 'タシルハイト語 (ティフナグ文字)',
        'shi-Tfng-MA' => 'タシルハイト語 (ティフナグ文字、モロッコ)',
        'si' => 'シンハラ語',
        'si-LK' => 'シンハラ語 (スリランカ)',
        'sk' => 'スロバキア語',
        'sk-SK' => 'スロバキア語 (スロバキア)',
        'sl' => 'スロベニア語',
        'sl-SI' => 'スロベニア語 (スロベニア)',
        'smn' => 'イナリ・サーミ語',
        'smn-FI' => 'イナリ・サーミ語 (フィンランド)',
        'sn' => 'ショナ語',
        'sn-ZW' => 'ショナ語 (ジンバブエ)',
        'so' => 'ソマリ語',
        'so-DJ' => 'ソマリ語 (ジブチ)',
        'so-ET' => 'ソマリ語 (エチオピア)',
        'so-KE' => 'ソマリ語 (ケニア)',
        'so-SO' => 'ソマリ語 (ソマリア)',
        'sq' => 'アルバニア語',
        'sq-AL' => 'アルバニア語 (アルバニア)',
        'sq-MK' => 'アルバニア語 (マケドニア)',
        'sq-XK' => 'アルバニア語 (コソボ)',
        'sr' => 'セルビア語',
        'sr-Cyrl' => 'セルビア語 (キリル文字)',
        'sr-Cyrl-BA' => 'セルビア語 (キリル文字、ボスニア・ヘルツェゴビナ)',
        'sr-Cyrl-ME' => 'セルビア語 (キリル文字、モンテネグロ)',
        'sr-Cyrl-RS' => 'セルビア語 (キリル文字、セルビア)',
        'sr-Cyrl-XK' => 'セルビア語 (キリル文字、コソボ)',
        'sr-Latn' => 'セルビア語 (ラテン文字)',
        'sr-Latn-BA' => 'セルビア語 (ラテン文字、ボスニア・ヘルツェゴビナ)',
        'sr-Latn-ME' => 'セルビア語 (ラテン文字、モンテネグロ)',
        'sr-Latn-RS' => 'セルビア語 (ラテン文字、セルビア)',
        'sr-Latn-XK' => 'セルビア語 (ラテン文字、コソボ)',
        'sv' => 'スウェーデン語',
        'sv-AX' => 'スウェーデン語 (オーランド諸島)',
        'sv-FI' => 'スウェーデン語 (フィンランド)',
        'sv-SE' => 'スウェーデン語 (スウェーデン)',
        'sw' => 'スワヒリ語',
        'sw-CD' => 'スワヒリ語 (コンゴ民主共和国[キンシャサ])',
        'sw-KE' => 'スワヒリ語 (ケニア)',
        'sw-TZ' => 'スワヒリ語 (タンザニア)',
        'sw-UG' => 'スワヒリ語 (ウガンダ)',
        'ta' => 'タミル語',
        'ta-IN' => 'タミル語 (インド)',
        'ta-LK' => 'タミル語 (スリランカ)',
        'ta-MY' => 'タミル語 (マレーシア)',
        'ta-SG' => 'タミル語 (シンガポール)',
        'te' => 'テルグ語',
        'te-IN' => 'テルグ語 (インド)',
        'teo' => 'テソ語',
        'teo-KE' => 'テソ語 (ケニア)',
        'teo-UG' => 'テソ語 (ウガンダ)',
        'th' => 'タイ語',
        'th-TH' => 'タイ語 (タイ)',
        'ti' => 'ティグリニア語',
        'ti-ER' => 'ティグリニア語 (エリトリア)',
        'ti-ET' => 'ティグリニア語 (エチオピア)',
        'to' => 'トンガ語',
        'to-TO' => 'トンガ語 (トンガ)',
        'tr' => 'トルコ語',
        'tr-CY' => 'トルコ語 (キプロス)',
        'tr-TR' => 'トルコ語 (トルコ)',
        'twq' => 'タサワク語',
        'twq-NE' => 'タサワク語 (ニジェール)',
        'tzm' => '中央アトラス・タマジクト語',
        'tzm-MA' => '中央アトラス・タマジクト語 (モロッコ)',
        'ug' => 'ウイグル語',
        'ug-CN' => 'ウイグル語 (中国)',
        'uk' => 'ウクライナ語',
        'uk-UA' => 'ウクライナ語 (ウクライナ)',
        'ur' => 'ウルドゥー語',
        'ur-IN' => 'ウルドゥー語 (インド)',
        'ur-PK' => 'ウルドゥー語 (パキスタン)',
        'uz' => 'ウズベク語',
        'uz-Arab' => 'ウズベク語 (アラビア文字)',
        'uz-Arab-AF' => 'ウズベク語 (アラビア文字、アフガニスタン)',
        'uz-Cyrl' => 'ウズベク語 (キリル文字)',
        'uz-Cyrl-UZ' => 'ウズベク語 (キリル文字、ウズベキスタン)',
        'uz-Latn' => 'ウズベク語 (ラテン文字)',
        'uz-Latn-UZ' => 'ウズベク語 (ラテン文字、ウズベキスタン)',
        'vai' => 'ヴァイ語',
        'vai-Latn' => 'ヴァイ語 (ラテン文字)',
        'vai-Latn-LR' => 'ヴァイ語 (ラテン文字、リベリア)',
        'vai-Vaii' => 'ヴァイ語 (ヴァイ文字)',
        'vai-Vaii-LR' => 'ヴァイ語 (ヴァイ文字、リベリア)',
        'vi' => 'ベトナム語',
        'vi-VN' => 'ベトナム語 (ベトナム)',
        'vun' => 'ヴンジョ語',
        'vun-TZ' => 'ヴンジョ語 (タンザニア)',
        'wae' => 'ヴァリス語',
        'wae-CH' => 'ヴァリス語 (スイス)',
        'xog' => 'ソガ語',
        'xog-UG' => 'ソガ語 (ウガンダ)',
        'yav' => 'ヤンベン語',
        'yav-CM' => 'ヤンベン語 (カメルーン)',
        'yi' => 'イディッシュ語',
        'yi-001' => 'イディッシュ語 (世界)',
        'yo' => 'ヨルバ語',
        'yo-BJ' => 'ヨルバ語 (ベナン)',
        'yo-NG' => 'ヨルバ語 (ナイジェリア)',
        'yue' => '広東語',
        'yue-HK' => '広東語 (中華人民共和国香港特別行政区)',
        'zgh' => 'タマージク語(モロッコ公用語)',
        'zgh-MA' => 'タマージク語(モロッコ公用語) (モロッコ)',
        'zh' => '中国語',
        'zh-Hans' => '中国語 (簡体字)',
        'zh-Hans-CN' => '中国語 (簡体字、中国)',
        'zh-Hans-HK' => '中国語 (簡体字、中華人民共和国香港特別行政区)',
        'zh-Hans-MO' => '中国語 (簡体字、中華人民共和国マカオ特別行政区)',
        'zh-Hans-SG' => '中国語 (簡体字、シンガポール)',
        'zh-Hant' => '中国語 (繁体字)',
        'zh-Hant-HK' => '中国語 (繁体字、中華人民共和国香港特別行政区)',
        'zh-Hant-MO' => '中国語 (繁体字、中華人民共和国マカオ特別行政区)',
        'zh-Hant-TW' => '中国語 (繁体字、台湾)',
        'zu' => 'ズールー語',
        'zu-ZA' => 'ズールー語 (南アフリカ)',
    ],
];
