<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd/M/yyyy',
            'time' => 'HH:mm',
            'datetime' => 'd/M/yyyy, HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y, HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE d MMMM y HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'BRL',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HKD',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JPY',
        'KRW' => 'KRW',
        'MXN' => 'MXN',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'TWD',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic',
        ],
        'full' => [
            'Gennaio',
            'Febbraio',
            'Marzo',
            'Aprile',
            'Maggio',
            'Giugno',
            'Luglio',
            'Agosto',
            'Settembre',
            'Ottobre',
            'Novembre',
            'Dicembre',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic',
        ],
        'full' => [
            'gennaio',
            'febbraio',
            'marzo',
            'aprile',
            'maggio',
            'giugno',
            'luglio',
            'agosto',
            'settembre',
            'ottobre',
            'novembre',
            'dicembre',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'M',
            'G',
            'V',
            'S',
        ],
        'short' => [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab',
        ],
        'medium' => [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab',
        ],
        'full' => [
            'Domenica',
            'Lunedì',
            'Martedì',
            'Mercoledì',
            'Giovedì',
            'Venerdì',
            'Sabato',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'M',
            'G',
            'V',
            'S',
        ],
        'short' => [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab',
        ],
        'medium' => [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab',
        ],
        'full' => [
            'domenica',
            'lunedì',
            'martedì',
            'mercoledì',
            'giovedì',
            'venerdì',
            'sabato',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Sudafrica)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Camerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amarico',
        'am-ET' => 'amarico (Etiopia)',
        'ar' => 'arabo',
        'ar-001' => 'arabo (Mondo)',
        'ar-AE' => 'arabo (Emirati Arabi Uniti)',
        'ar-BH' => 'arabo (Bahrein)',
        'ar-DJ' => 'arabo (Gibuti)',
        'ar-DZ' => 'arabo (Algeria)',
        'ar-EG' => 'arabo (Egitto)',
        'ar-EH' => 'arabo (Sahara occidentale)',
        'ar-ER' => 'arabo (Eritrea)',
        'ar-IL' => 'arabo (Israele)',
        'ar-IQ' => 'arabo (Iraq)',
        'ar-JO' => 'arabo (Giordania)',
        'ar-KM' => 'arabo (Comore)',
        'ar-KW' => 'arabo (Kuwait)',
        'ar-LB' => 'arabo (Libano)',
        'ar-LY' => 'arabo (Libia)',
        'ar-MA' => 'arabo (Marocco)',
        'ar-MR' => 'arabo (Mauritania)',
        'ar-OM' => 'arabo (Oman)',
        'ar-PS' => 'arabo (Territori palestinesi)',
        'ar-QA' => 'arabo (Qatar)',
        'ar-SA' => 'arabo (Arabia Saudita)',
        'ar-SD' => 'arabo (Sudan)',
        'ar-SO' => 'arabo (Somalia)',
        'ar-SS' => 'arabo (Sud Sudan)',
        'ar-SY' => 'arabo (Siria)',
        'ar-TD' => 'arabo (Ciad)',
        'ar-TN' => 'arabo (Tunisia)',
        'ar-YE' => 'arabo (Yemen)',
        'as' => 'assamese',
        'as-IN' => 'assamese (India)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturiano',
        'ast-ES' => 'asturiano (Spagna)',
        'az' => 'azerbaigiano',
        'az-Cyrl' => 'azerbaigiano (cirillico)',
        'az-Cyrl-AZ' => 'azerbaigiano (cirillico, Azerbaigian)',
        'az-Latn' => 'azerbaigiano (latino)',
        'az-Latn-AZ' => 'azerbaigiano (latino, Azerbaigian)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Camerun)',
        'be' => 'bielorusso',
        'be-BY' => 'bielorusso (Bielorussia)',
        'bem' => 'wemba',
        'bem-ZM' => 'wemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'bulgaro',
        'bg-BG' => 'bulgaro (Bulgaria)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengalese',
        'bn-BD' => 'bengalese (Bangladesh)',
        'bn-IN' => 'bengalese (India)',
        'bo' => 'tibetano',
        'bo-CN' => 'tibetano (Cina)',
        'bo-IN' => 'tibetano (India)',
        'br' => 'bretone',
        'br-FR' => 'bretone (Francia)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosniaco',
        'bs-Cyrl' => 'bosniaco (cirillico)',
        'bs-Cyrl-BA' => 'bosniaco (cirillico, Bosnia ed Erzegovina)',
        'bs-Latn' => 'bosniaco (latino)',
        'bs-Latn-BA' => 'bosniaco (latino, Bosnia ed Erzegovina)',
        'ca' => 'catalano',
        'ca-AD' => 'catalano (Andorra)',
        'ca-ES' => 'catalano (Spagna)',
        'ca-FR' => 'catalano (Francia)',
        'ca-IT' => 'catalano (Italia)',
        'ce' => 'ceceno',
        'ce-RU' => 'ceceno (Russia)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'cherokee',
        'chr-US' => 'cherokee (Stati Uniti)',
        'cs' => 'ceco',
        'cs-CZ' => 'ceco (Repubblica Ceca)',
        'cy' => 'gallese',
        'cy-GB' => 'gallese (Regno Unito)',
        'da' => 'danese',
        'da-DK' => 'danese (Danimarca)',
        'da-GL' => 'danese (Groenlandia)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'tedesco',
        'de-AT' => 'tedesco (Austria)',
        'de-BE' => 'tedesco (Belgio)',
        'de-CH' => 'tedesco (Svizzera)',
        'de-DE' => 'tedesco (Germania)',
        'de-LI' => 'tedesco (Liechtenstein)',
        'de-LU' => 'tedesco (Lussemburgo)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'basso sorabo',
        'dsb-DE' => 'basso sorabo (Germania)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Camerun)',
        'dyo' => 'jola-fony',
        'dyo-SN' => 'jola-fony (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhutan)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Kenya)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'greco',
        'el-CY' => 'greco (Cipro)',
        'el-GR' => 'greco (Grecia)',
        'en' => 'inglese',
        'en-001' => 'inglese (Mondo)',
        'en-150' => 'inglese (Europa)',
        'en-AG' => 'inglese (Antigua e Barbuda)',
        'en-AI' => 'inglese (Anguilla)',
        'en-AS' => 'inglese (Samoa americane)',
        'en-AT' => 'inglese (Austria)',
        'en-AU' => 'inglese (Australia)',
        'en-BB' => 'inglese (Barbados)',
        'en-BE' => 'inglese (Belgio)',
        'en-BI' => 'inglese (Burundi)',
        'en-BM' => 'inglese (Bermuda)',
        'en-BS' => 'inglese (Bahamas)',
        'en-BW' => 'inglese (Botswana)',
        'en-BZ' => 'inglese (Belize)',
        'en-CA' => 'inglese (Canada)',
        'en-CC' => 'inglese (Isole Cocos [Keeling])',
        'en-CH' => 'inglese (Svizzera)',
        'en-CK' => 'inglese (Isole Cook)',
        'en-CM' => 'inglese (Camerun)',
        'en-CX' => 'inglese (Isola Christmas)',
        'en-CY' => 'inglese (Cipro)',
        'en-DE' => 'inglese (Germania)',
        'en-DG' => 'inglese (Diego Garcia)',
        'en-DK' => 'inglese (Danimarca)',
        'en-DM' => 'inglese (Dominica)',
        'en-ER' => 'inglese (Eritrea)',
        'en-FI' => 'inglese (Finlandia)',
        'en-FJ' => 'inglese (Figi)',
        'en-FK' => 'inglese (Isole Falkland)',
        'en-FM' => 'inglese (Micronesia)',
        'en-GB' => 'inglese (Regno Unito)',
        'en-GD' => 'inglese (Grenada)',
        'en-GG' => 'inglese (Guernsey)',
        'en-GH' => 'inglese (Ghana)',
        'en-GI' => 'inglese (Gibilterra)',
        'en-GM' => 'inglese (Gambia)',
        'en-GU' => 'inglese (Guam)',
        'en-GY' => 'inglese (Guyana)',
        'en-HK' => 'inglese (RAS di Hong Kong)',
        'en-IE' => 'inglese (Irlanda)',
        'en-IL' => 'inglese (Israele)',
        'en-IM' => 'inglese (Isola di Man)',
        'en-IN' => 'inglese (India)',
        'en-IO' => 'inglese (Territorio britannico dell’Oceano Indiano)',
        'en-JE' => 'inglese (Jersey)',
        'en-JM' => 'inglese (Giamaica)',
        'en-KE' => 'inglese (Kenya)',
        'en-KI' => 'inglese (Kiribati)',
        'en-KN' => 'inglese (Saint Kitts e Nevis)',
        'en-KY' => 'inglese (Isole Cayman)',
        'en-LC' => 'inglese (Saint Lucia)',
        'en-LR' => 'inglese (Liberia)',
        'en-LS' => 'inglese (Lesotho)',
        'en-MG' => 'inglese (Madagascar)',
        'en-MH' => 'inglese (Isole Marshall)',
        'en-MO' => 'inglese (RAS di Macao)',
        'en-MP' => 'inglese (Isole Marianne settentrionali)',
        'en-MS' => 'inglese (Montserrat)',
        'en-MT' => 'inglese (Malta)',
        'en-MU' => 'inglese (Mauritius)',
        'en-MW' => 'inglese (Malawi)',
        'en-MY' => 'inglese (Malaysia)',
        'en-NA' => 'inglese (Namibia)',
        'en-NF' => 'inglese (Isola Norfolk)',
        'en-NG' => 'inglese (Nigeria)',
        'en-NL' => 'inglese (Paesi Bassi)',
        'en-NR' => 'inglese (Nauru)',
        'en-NU' => 'inglese (Niue)',
        'en-NZ' => 'inglese (Nuova Zelanda)',
        'en-PG' => 'inglese (Papua Nuova Guinea)',
        'en-PH' => 'inglese (Filippine)',
        'en-PK' => 'inglese (Pakistan)',
        'en-PN' => 'inglese (Isole Pitcairn)',
        'en-PR' => 'inglese (Portorico)',
        'en-PW' => 'inglese (Palau)',
        'en-RW' => 'inglese (Ruanda)',
        'en-SB' => 'inglese (Isole Salomone)',
        'en-SC' => 'inglese (Seychelles)',
        'en-SD' => 'inglese (Sudan)',
        'en-SE' => 'inglese (Svezia)',
        'en-SG' => 'inglese (Singapore)',
        'en-SH' => 'inglese (Sant’Elena)',
        'en-SI' => 'inglese (Slovenia)',
        'en-SL' => 'inglese (Sierra Leone)',
        'en-SS' => 'inglese (Sud Sudan)',
        'en-SX' => 'inglese (Sint Maarten)',
        'en-SZ' => 'inglese (Swaziland)',
        'en-TC' => 'inglese (Isole Turks e Caicos)',
        'en-TK' => 'inglese (Tokelau)',
        'en-TO' => 'inglese (Tonga)',
        'en-TT' => 'inglese (Trinidad e Tobago)',
        'en-TV' => 'inglese (Tuvalu)',
        'en-TZ' => 'inglese (Tanzania)',
        'en-UG' => 'inglese (Uganda)',
        'en-UM' => 'inglese (Altre isole americane del Pacifico)',
        'en-US' => 'inglese (Stati Uniti)',
        'en-US-POSIX' => 'inglese (Stati Uniti, computer)',
        'en-VC' => 'inglese (Saint Vincent e Grenadines)',
        'en-VG' => 'inglese (Isole Vergini Britanniche)',
        'en-VI' => 'inglese (Isole Vergini Americane)',
        'en-VU' => 'inglese (Vanuatu)',
        'en-WS' => 'inglese (Samoa)',
        'en-ZA' => 'inglese (Sudafrica)',
        'en-ZM' => 'inglese (Zambia)',
        'en-ZW' => 'inglese (Zimbabwe)',
        'eo' => 'esperanto',
        'es' => 'spagnolo',
        'es-419' => 'spagnolo (America Latina)',
        'es-AR' => 'spagnolo (Argentina)',
        'es-BO' => 'spagnolo (Bolivia)',
        'es-CL' => 'spagnolo (Cile)',
        'es-CO' => 'spagnolo (Colombia)',
        'es-CR' => 'spagnolo (Costa Rica)',
        'es-CU' => 'spagnolo (Cuba)',
        'es-DO' => 'spagnolo (Repubblica Dominicana)',
        'es-EA' => 'spagnolo (Ceuta e Melilla)',
        'es-EC' => 'spagnolo (Ecuador)',
        'es-ES' => 'spagnolo (Spagna)',
        'es-GQ' => 'spagnolo (Guinea Equatoriale)',
        'es-GT' => 'spagnolo (Guatemala)',
        'es-HN' => 'spagnolo (Honduras)',
        'es-IC' => 'spagnolo (Isole Canarie)',
        'es-MX' => 'spagnolo (Messico)',
        'es-NI' => 'spagnolo (Nicaragua)',
        'es-PA' => 'spagnolo (Panamá)',
        'es-PE' => 'spagnolo (Perù)',
        'es-PH' => 'spagnolo (Filippine)',
        'es-PR' => 'spagnolo (Portorico)',
        'es-PY' => 'spagnolo (Paraguay)',
        'es-SV' => 'spagnolo (El Salvador)',
        'es-US' => 'spagnolo (Stati Uniti)',
        'es-UY' => 'spagnolo (Uruguay)',
        'es-VE' => 'spagnolo (Venezuela)',
        'et' => 'estone',
        'et-EE' => 'estone (Estonia)',
        'eu' => 'basco',
        'eu-ES' => 'basco (Spagna)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Camerun)',
        'fa' => 'persiano',
        'fa-AF' => 'persiano (Afghanistan)',
        'fa-IR' => 'persiano (Iran)',
        'ff' => 'fulah',
        'ff-CM' => 'fulah (Camerun)',
        'ff-GN' => 'fulah (Guinea)',
        'ff-MR' => 'fulah (Mauritania)',
        'ff-SN' => 'fulah (Senegal)',
        'fi' => 'finlandese',
        'fi-FI' => 'finlandese (Finlandia)',
        'fil' => 'filippino',
        'fil-PH' => 'filippino (Filippine)',
        'fo' => 'faroese',
        'fo-DK' => 'faroese (Danimarca)',
        'fo-FO' => 'faroese (Isole Fær Øer)',
        'fr' => 'francese',
        'fr-BE' => 'francese (Belgio)',
        'fr-BF' => 'francese (Burkina Faso)',
        'fr-BI' => 'francese (Burundi)',
        'fr-BJ' => 'francese (Benin)',
        'fr-BL' => 'francese (Saint-Barthélemy)',
        'fr-CA' => 'francese (Canada)',
        'fr-CD' => 'francese (Congo - Kinshasa)',
        'fr-CF' => 'francese (Repubblica Centrafricana)',
        'fr-CG' => 'francese (Congo-Brazzaville)',
        'fr-CH' => 'francese (Svizzera)',
        'fr-CI' => 'francese (Costa d’Avorio)',
        'fr-CM' => 'francese (Camerun)',
        'fr-DJ' => 'francese (Gibuti)',
        'fr-DZ' => 'francese (Algeria)',
        'fr-FR' => 'francese (Francia)',
        'fr-GA' => 'francese (Gabon)',
        'fr-GF' => 'francese (Guyana francese)',
        'fr-GN' => 'francese (Guinea)',
        'fr-GP' => 'francese (Guadalupa)',
        'fr-GQ' => 'francese (Guinea Equatoriale)',
        'fr-HT' => 'francese (Haiti)',
        'fr-KM' => 'francese (Comore)',
        'fr-LU' => 'francese (Lussemburgo)',
        'fr-MA' => 'francese (Marocco)',
        'fr-MC' => 'francese (Monaco)',
        'fr-MF' => 'francese (Saint Martin)',
        'fr-MG' => 'francese (Madagascar)',
        'fr-ML' => 'francese (Mali)',
        'fr-MQ' => 'francese (Martinica)',
        'fr-MR' => 'francese (Mauritania)',
        'fr-MU' => 'francese (Mauritius)',
        'fr-NC' => 'francese (Nuova Caledonia)',
        'fr-NE' => 'francese (Niger)',
        'fr-PF' => 'francese (Polinesia francese)',
        'fr-PM' => 'francese (Saint Pierre e Miquelon)',
        'fr-RE' => 'francese (Riunione)',
        'fr-RW' => 'francese (Ruanda)',
        'fr-SC' => 'francese (Seychelles)',
        'fr-SN' => 'francese (Senegal)',
        'fr-SY' => 'francese (Siria)',
        'fr-TD' => 'francese (Ciad)',
        'fr-TG' => 'francese (Togo)',
        'fr-TN' => 'francese (Tunisia)',
        'fr-VU' => 'francese (Vanuatu)',
        'fr-WF' => 'francese (Wallis e Futuna)',
        'fr-YT' => 'francese (Mayotte)',
        'fur' => 'friulano',
        'fur-IT' => 'friulano (Italia)',
        'fy' => 'frisone occidentale',
        'fy-NL' => 'frisone occidentale (Paesi Bassi)',
        'ga' => 'irlandese',
        'ga-IE' => 'irlandese (Irlanda)',
        'gd' => 'gaelico scozzese',
        'gd-GB' => 'gaelico scozzese (Regno Unito)',
        'gl' => 'galiziano',
        'gl-ES' => 'galiziano (Spagna)',
        'gsw' => 'tedesco svizzero',
        'gsw-CH' => 'tedesco svizzero (Svizzera)',
        'gsw-FR' => 'tedesco svizzero (Francia)',
        'gsw-LI' => 'tedesco svizzero (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (India)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenya)',
        'gv' => 'mannese',
        'gv-IM' => 'mannese (Isola di Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiano',
        'haw-US' => 'hawaiano (Stati Uniti)',
        'he' => 'ebraico',
        'he-IL' => 'ebraico (Israele)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (India)',
        'hr' => 'croato',
        'hr-BA' => 'croato (Bosnia ed Erzegovina)',
        'hr-HR' => 'croato (Croazia)',
        'hsb' => 'alto sorabo',
        'hsb-DE' => 'alto sorabo (Germania)',
        'hu' => 'ungherese',
        'hu-HU' => 'ungherese (Ungheria)',
        'hy' => 'armeno',
        'hy-AM' => 'armeno (Armenia)',
        'id' => 'indonesiano',
        'id-ID' => 'indonesiano (Indonesia)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigeria)',
        'ii' => 'sichuan yi',
        'ii-CN' => 'sichuan yi (Cina)',
        'is' => 'islandese',
        'is-IS' => 'islandese (Islanda)',
        'it' => 'italiano',
        'it-CH' => 'italiano (Svizzera)',
        'it-IT' => 'italiano (Italia)',
        'it-SM' => 'italiano (San Marino)',
        'ja' => 'giapponese',
        'ja-JP' => 'giapponese (Giappone)',
        'jgo' => 'ngamambo',
        'jgo-CM' => 'ngamambo (Camerun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzania)',
        'ka' => 'georgiano',
        'ka-GE' => 'georgiano (Georgia)',
        'kab' => 'cabilo',
        'kab-DZ' => 'cabilo (Algeria)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'capoverdiano',
        'kea-CV' => 'capoverdiano (Capo Verde)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kazako',
        'kk-KZ' => 'kazako (Kazakistan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Camerun)',
        'kl' => 'groenlandese',
        'kl-GL' => 'groenlandese (Groenlandia)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Cambogia)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (India)',
        'ko' => 'coreano',
        'ko-KP' => 'coreano (Corea del Nord)',
        'ko-KR' => 'coreano (Corea del Sud)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (India)',
        'ks' => 'kashmiri',
        'ks-IN' => 'kashmiri (India)',
        'ksb' => 'shambala',
        'ksb-TZ' => 'shambala (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Camerun)',
        'ksh' => 'coloniese',
        'ksh-DE' => 'coloniese (Germania)',
        'kw' => 'cornico',
        'kw-GB' => 'cornico (Regno Unito)',
        'ky' => 'chirghiso',
        'ky-KG' => 'chirghiso (Kirghizistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'lussemburghese',
        'lb-LU' => 'lussemburghese (Lussemburgo)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (Stati Uniti)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Congo - Kinshasa)',
        'ln-CF' => 'lingala (Repubblica Centrafricana)',
        'ln-CG' => 'lingala (Congo-Brazzaville)',
        'lo' => 'lao',
        'lo-LA' => 'lao (Laos)',
        'lrc' => 'luri settentrionale',
        'lrc-IQ' => 'luri settentrionale (Iraq)',
        'lrc-IR' => 'luri settentrionale (Iran)',
        'lt' => 'lituano',
        'lt-LT' => 'lituano (Lituania)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Congo - Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'luyia',
        'luy-KE' => 'luyia (Kenya)',
        'lv' => 'lettone',
        'lv-LV' => 'lettone (Lettonia)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenya)',
        'mfe' => 'creolo mauriziano',
        'mfe-MU' => 'creolo mauriziano (Mauritius)',
        'mg' => 'malgascio',
        'mg-MG' => 'malgascio (Madagascar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mozambico)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Camerun)',
        'mk' => 'macedone',
        'mk-MK' => 'macedone (Repubblica di Macedonia)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (India)',
        'mn' => 'mongolo',
        'mn-MN' => 'mongolo (Mongolia)',
        'mr' => 'marathi',
        'mr-IN' => 'marathi (India)',
        'ms' => 'malese',
        'ms-BN' => 'malese (Brunei)',
        'ms-MY' => 'malese (Malaysia)',
        'ms-SG' => 'malese (Singapore)',
        'mt' => 'maltese',
        'mt-MT' => 'maltese (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Camerun)',
        'my' => 'birmano',
        'my-MM' => 'birmano (Myanmar [Birmania])',
        'mzn' => 'mazandarani',
        'mzn-IR' => 'mazandarani (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'norvegese bokmål',
        'nb-NO' => 'norvegese bokmål (Norvegia)',
        'nb-SJ' => 'norvegese bokmål (Svalbard e Jan Mayen)',
        'nd' => 'ndebele del nord',
        'nd-ZW' => 'ndebele del nord (Zimbabwe)',
        'ne' => 'nepalese',
        'ne-IN' => 'nepalese (India)',
        'ne-NP' => 'nepalese (Nepal)',
        'nl' => 'olandese',
        'nl-AW' => 'olandese (Aruba)',
        'nl-BE' => 'olandese (Belgio)',
        'nl-BQ' => 'olandese (Caraibi Olandesi)',
        'nl-CW' => 'olandese (Curaçao)',
        'nl-NL' => 'olandese (Paesi Bassi)',
        'nl-SR' => 'olandese (Suriname)',
        'nl-SX' => 'olandese (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Camerun)',
        'nn' => 'norvegese nynorsk',
        'nn-NO' => 'norvegese nynorsk (Norvegia)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Camerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sud Sudan)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopia)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'oriya',
        'or-IN' => 'oriya (India)',
        'os' => 'ossetico',
        'os-GE' => 'ossetico (Georgia)',
        'os-RU' => 'ossetico (Russia)',
        'pa' => 'punjabi',
        'pa-Arab' => 'punjabi (arabo)',
        'pa-Arab-PK' => 'punjabi (arabo, Pakistan)',
        'pa-Guru' => 'punjabi (gurmukhi)',
        'pa-Guru-IN' => 'punjabi (gurmukhi, India)',
        'pl' => 'polacco',
        'pl-PL' => 'polacco (Polonia)',
        'ps' => 'pashto',
        'ps-AF' => 'pashto (Afghanistan)',
        'pt' => 'portoghese',
        'pt-AO' => 'portoghese (Angola)',
        'pt-BR' => 'portoghese (Brasile)',
        'pt-CV' => 'portoghese (Capo Verde)',
        'pt-GW' => 'portoghese (Guinea-Bissau)',
        'pt-MO' => 'portoghese (RAS di Macao)',
        'pt-MZ' => 'portoghese (Mozambico)',
        'pt-PT' => 'portoghese (Portogallo)',
        'pt-ST' => 'portoghese (São Tomé e Príncipe)',
        'pt-TL' => 'portoghese (Timor Leste)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Perù)',
        'rm' => 'romancio',
        'rm-CH' => 'romancio (Svizzera)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumeno',
        'ro-MD' => 'rumeno (Moldavia)',
        'ro-RO' => 'rumeno (Romania)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'russo',
        'ru-BY' => 'russo (Bielorussia)',
        'ru-KG' => 'russo (Kirghizistan)',
        'ru-KZ' => 'russo (Kazakistan)',
        'ru-MD' => 'russo (Moldavia)',
        'ru-RU' => 'russo (Russia)',
        'ru-UA' => 'russo (Ucraina)',
        'rw' => 'kinyarwanda',
        'rw-RW' => 'kinyarwanda (Ruanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'yakut',
        'sah-RU' => 'yakut (Russia)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'sami del nord',
        'se-FI' => 'sami del nord (Finlandia)',
        'se-NO' => 'sami del nord (Norvegia)',
        'se-SE' => 'sami del nord (Svezia)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambico)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Repubblica Centrafricana)',
        'shi' => 'tashelhit',
        'shi-Latn' => 'tashelhit (latino)',
        'shi-Latn-MA' => 'tashelhit (latino, Marocco)',
        'shi-Tfng' => 'tashelhit (tifinagh)',
        'shi-Tfng-MA' => 'tashelhit (tifinagh, Marocco)',
        'si' => 'singalese',
        'si-LK' => 'singalese (Sri Lanka)',
        'sk' => 'slovacco',
        'sk-SK' => 'slovacco (Slovacchia)',
        'sl' => 'sloveno',
        'sl-SI' => 'sloveno (Slovenia)',
        'smn' => 'sami di Inari',
        'smn-FI' => 'sami di Inari (Finlandia)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somalo',
        'so-DJ' => 'somalo (Gibuti)',
        'so-ET' => 'somalo (Etiopia)',
        'so-KE' => 'somalo (Kenya)',
        'so-SO' => 'somalo (Somalia)',
        'sq' => 'albanese',
        'sq-AL' => 'albanese (Albania)',
        'sq-MK' => 'albanese (Repubblica di Macedonia)',
        'sq-XK' => 'albanese (Kosovo)',
        'sr' => 'serbo',
        'sr-Cyrl' => 'serbo (cirillico)',
        'sr-Cyrl-BA' => 'serbo (cirillico, Bosnia ed Erzegovina)',
        'sr-Cyrl-ME' => 'serbo (cirillico, Montenegro)',
        'sr-Cyrl-RS' => 'serbo (cirillico, Serbia)',
        'sr-Cyrl-XK' => 'serbo (cirillico, Kosovo)',
        'sr-Latn' => 'serbo (latino)',
        'sr-Latn-BA' => 'serbo (latino, Bosnia ed Erzegovina)',
        'sr-Latn-ME' => 'serbo (latino, Montenegro)',
        'sr-Latn-RS' => 'serbo (latino, Serbia)',
        'sr-Latn-XK' => 'serbo (latino, Kosovo)',
        'sv' => 'svedese',
        'sv-AX' => 'svedese (Isole Åland)',
        'sv-FI' => 'svedese (Finlandia)',
        'sv-SE' => 'svedese (Svezia)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Congo - Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzania)',
        'sw-UG' => 'swahili (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (India)',
        'ta-LK' => 'tamil (Sri Lanka)',
        'ta-MY' => 'tamil (Malaysia)',
        'ta-SG' => 'tamil (Singapore)',
        'te' => 'telugu',
        'te-IN' => 'telugu (India)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenya)',
        'teo-UG' => 'teso (Uganda)',
        'th' => 'thai',
        'th-TH' => 'thai (Thailandia)',
        'ti' => 'tigrino',
        'ti-ER' => 'tigrino (Eritrea)',
        'ti-ET' => 'tigrino (Etiopia)',
        'to' => 'tongano',
        'to-TO' => 'tongano (Tonga)',
        'tr' => 'turco',
        'tr-CY' => 'turco (Cipro)',
        'tr-TR' => 'turco (Turchia)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'tamazight',
        'tzm-MA' => 'tamazight (Marocco)',
        'ug' => 'uiguro',
        'ug-CN' => 'uiguro (Cina)',
        'uk' => 'ucraino',
        'uk-UA' => 'ucraino (Ucraina)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (India)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'usbeco',
        'uz-Arab' => 'usbeco (arabo)',
        'uz-Arab-AF' => 'usbeco (arabo, Afghanistan)',
        'uz-Cyrl' => 'usbeco (cirillico)',
        'uz-Cyrl-UZ' => 'usbeco (cirillico, Uzbekistan)',
        'uz-Latn' => 'usbeco (latino)',
        'uz-Latn-UZ' => 'usbeco (latino, Uzbekistan)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latino)',
        'vai-Latn-LR' => 'vai (latino, Liberia)',
        'vai-Vaii' => 'vai (vaii)',
        'vai-Vaii-LR' => 'vai (vaii, Liberia)',
        'vi' => 'vietnamita',
        'vi-VN' => 'vietnamita (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Svizzera)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Camerun)',
        'yi' => 'yiddish',
        'yi-001' => 'yiddish (Mondo)',
        'yo' => 'yoruba',
        'yo-BJ' => 'yoruba (Benin)',
        'yo-NG' => 'yoruba (Nigeria)',
        'yue' => 'cantonese',
        'yue-HK' => 'cantonese (RAS di Hong Kong)',
        'zgh' => 'tamazight del Marocco standard',
        'zgh-MA' => 'tamazight del Marocco standard (Marocco)',
        'zh' => 'cinese',
        'zh-Hans' => 'cinese (semplificato)',
        'zh-Hans-CN' => 'cinese (semplificato, Cina)',
        'zh-Hans-HK' => 'cinese (semplificato, RAS di Hong Kong)',
        'zh-Hans-MO' => 'cinese (semplificato, RAS di Macao)',
        'zh-Hans-SG' => 'cinese (semplificato, Singapore)',
        'zh-Hant' => 'cinese (tradizionale)',
        'zh-Hant-HK' => 'cinese (tradizionale, RAS di Hong Kong)',
        'zh-Hant-MO' => 'cinese (tradizionale, RAS di Macao)',
        'zh-Hant-TW' => 'cinese (tradizionale, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Sudafrica)',
    ],
];
