<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd/M/yyyy',
            'time' => 'H:mm',
            'datetime' => 'd/M/yyyy H:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'H:mm:ss',
            'datetime' => 'd MMM y H:mm:ss',
        ],
        'long' => [
            'date' => 'd \'de\' MMMM \'de\' y',
            'time' => 'H:mm:ss z',
            'datetime' => 'd \'de\' MMMM \'de\' y, H:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d \'de\' MMMM \'de\' y',
            'time' => 'H:mm:ss (zzzz)',
            'datetime' => 'EEEE, d \'de\' MMMM \'de\' y, H:mm:ss (zzzz)',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'a. m.',
    'pmName' => 'p. m.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD',
        'BRL' => 'BRL',
        'CAD' => 'CA$',
        'CNY' => 'CNY',
        'EUR' => '€',
        'GBP' => 'GBP',
        'HKD' => 'HKD',
        'ILS' => 'ILS',
        'INR' => 'INR',
        'JPY' => 'JPY',
        'KRW' => 'KRW',
        'MXN' => 'MXN',
        'NZD' => 'NZD',
        'THB' => '฿',
        'TWD' => 'TWD',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'XAF',
        'XCD' => 'XCD',
        'XOF' => 'XOF',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.',
        ],
        'full' => [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.',
        ],
        'full' => [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'X',
            'J',
            'V',
            'S',
        ],
        'short' => [
            'DO',
            'LU',
            'MA',
            'MI',
            'JU',
            'VI',
            'SA',
        ],
        'medium' => [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.',
        ],
        'full' => [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'X',
            'J',
            'V',
            'S',
        ],
        'short' => [
            'DO',
            'LU',
            'MA',
            'MI',
            'JU',
            'VI',
            'SA',
        ],
        'medium' => [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.',
        ],
        'full' => [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikáans',
        'af-NA' => 'afrikáans (Namibia)',
        'af-ZA' => 'afrikáans (Sudáfrica)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Camerún)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amárico',
        'am-ET' => 'amárico (Etiopía)',
        'ar' => 'árabe',
        'ar-001' => 'árabe (Mundo)',
        'ar-AE' => 'árabe (Emiratos Árabes Unidos)',
        'ar-BH' => 'árabe (Baréin)',
        'ar-DJ' => 'árabe (Yibuti)',
        'ar-DZ' => 'árabe (Argelia)',
        'ar-EG' => 'árabe (Egipto)',
        'ar-EH' => 'árabe (Sáhara Occidental)',
        'ar-ER' => 'árabe (Eritrea)',
        'ar-IL' => 'árabe (Israel)',
        'ar-IQ' => 'árabe (Irak)',
        'ar-JO' => 'árabe (Jordania)',
        'ar-KM' => 'árabe (Comoras)',
        'ar-KW' => 'árabe (Kuwait)',
        'ar-LB' => 'árabe (Líbano)',
        'ar-LY' => 'árabe (Libia)',
        'ar-MA' => 'árabe (Marruecos)',
        'ar-MR' => 'árabe (Mauritania)',
        'ar-OM' => 'árabe (Omán)',
        'ar-PS' => 'árabe (Territorios Palestinos)',
        'ar-QA' => 'árabe (Catar)',
        'ar-SA' => 'árabe (Arabia Saudí)',
        'ar-SD' => 'árabe (Sudán)',
        'ar-SO' => 'árabe (Somalia)',
        'ar-SS' => 'árabe (Sudán del Sur)',
        'ar-SY' => 'árabe (Siria)',
        'ar-TD' => 'árabe (Chad)',
        'ar-TN' => 'árabe (Túnez)',
        'ar-YE' => 'árabe (Yemen)',
        'as' => 'asamés',
        'as-IN' => 'asamés (India)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturiano',
        'ast-ES' => 'asturiano (España)',
        'az' => 'azerbaiyano',
        'az-Cyrl' => 'azerbaiyano (cirílico)',
        'az-Cyrl-AZ' => 'azerbaiyano (cirílico, Azerbaiyán)',
        'az-Latn' => 'azerbaiyano (latín)',
        'az-Latn-AZ' => 'azerbaiyano (latín, Azerbaiyán)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Camerún)',
        'be' => 'bielorruso',
        'be-BY' => 'bielorruso (Bielorrusia)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'búlgaro',
        'bg-BG' => 'búlgaro (Bulgaria)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengalí',
        'bn-BD' => 'bengalí (Bangladés)',
        'bn-IN' => 'bengalí (India)',
        'bo' => 'tibetano',
        'bo-CN' => 'tibetano (China)',
        'bo-IN' => 'tibetano (India)',
        'br' => 'bretón',
        'br-FR' => 'bretón (Francia)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosnio',
        'bs-Cyrl' => 'bosnio (cirílico)',
        'bs-Cyrl-BA' => 'bosnio (cirílico, Bosnia-Herzegovina)',
        'bs-Latn' => 'bosnio (latín)',
        'bs-Latn-BA' => 'bosnio (latín, Bosnia-Herzegovina)',
        'ca' => 'catalán',
        'ca-AD' => 'catalán (Andorra)',
        'ca-ES' => 'catalán (España)',
        'ca-FR' => 'catalán (Francia)',
        'ca-IT' => 'catalán (Italia)',
        'ce' => 'checheno',
        'ce-RU' => 'checheno (Rusia)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'cheroqui',
        'chr-US' => 'cheroqui (Estados Unidos)',
        'cs' => 'checo',
        'cs-CZ' => 'checo (República Checa)',
        'cy' => 'galés',
        'cy-GB' => 'galés (Reino Unido)',
        'da' => 'danés',
        'da-DK' => 'danés (Dinamarca)',
        'da-GL' => 'danés (Groenlandia)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenia)',
        'de' => 'alemán',
        'de-AT' => 'alemán (Austria)',
        'de-BE' => 'alemán (Bélgica)',
        'de-CH' => 'alemán (Suiza)',
        'de-DE' => 'alemán (Alemania)',
        'de-LI' => 'alemán (Liechtenstein)',
        'de-LU' => 'alemán (Luxemburgo)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Níger)',
        'dsb' => 'bajo sorbio',
        'dsb-DE' => 'bajo sorbio (Alemania)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Camerún)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bután)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Kenia)',
        'ee' => 'ewé',
        'ee-GH' => 'ewé (Ghana)',
        'ee-TG' => 'ewé (Togo)',
        'el' => 'griego',
        'el-CY' => 'griego (Chipre)',
        'el-GR' => 'griego (Grecia)',
        'en' => 'inglés',
        'en-001' => 'inglés (Mundo)',
        'en-150' => 'inglés (Europa)',
        'en-AG' => 'inglés (Antigua y Barbuda)',
        'en-AI' => 'inglés (Anguila)',
        'en-AS' => 'inglés (Samoa Americana)',
        'en-AT' => 'inglés (Austria)',
        'en-AU' => 'inglés (Australia)',
        'en-BB' => 'inglés (Barbados)',
        'en-BE' => 'inglés (Bélgica)',
        'en-BI' => 'inglés (Burundi)',
        'en-BM' => 'inglés (Bermudas)',
        'en-BS' => 'inglés (Bahamas)',
        'en-BW' => 'inglés (Botsuana)',
        'en-BZ' => 'inglés (Belice)',
        'en-CA' => 'inglés (Canadá)',
        'en-CC' => 'inglés (Islas Cocos)',
        'en-CH' => 'inglés (Suiza)',
        'en-CK' => 'inglés (Islas Cook)',
        'en-CM' => 'inglés (Camerún)',
        'en-CX' => 'inglés (Isla de Navidad)',
        'en-CY' => 'inglés (Chipre)',
        'en-DE' => 'inglés (Alemania)',
        'en-DG' => 'inglés (Diego García)',
        'en-DK' => 'inglés (Dinamarca)',
        'en-DM' => 'inglés (Dominica)',
        'en-ER' => 'inglés (Eritrea)',
        'en-FI' => 'inglés (Finlandia)',
        'en-FJ' => 'inglés (Fiyi)',
        'en-FK' => 'inglés (Islas Malvinas)',
        'en-FM' => 'inglés (Micronesia)',
        'en-GB' => 'inglés (Reino Unido)',
        'en-GD' => 'inglés (Granada)',
        'en-GG' => 'inglés (Guernesey)',
        'en-GH' => 'inglés (Ghana)',
        'en-GI' => 'inglés (Gibraltar)',
        'en-GM' => 'inglés (Gambia)',
        'en-GU' => 'inglés (Guam)',
        'en-GY' => 'inglés (Guyana)',
        'en-HK' => 'inglés (RAE de Hong Kong [China])',
        'en-IE' => 'inglés (Irlanda)',
        'en-IL' => 'inglés (Israel)',
        'en-IM' => 'inglés (Isla de Man)',
        'en-IN' => 'inglés (India)',
        'en-IO' => 'inglés (Territorio Británico del Océano Índico)',
        'en-JE' => 'inglés (Jersey)',
        'en-JM' => 'inglés (Jamaica)',
        'en-KE' => 'inglés (Kenia)',
        'en-KI' => 'inglés (Kiribati)',
        'en-KN' => 'inglés (San Cristóbal y Nieves)',
        'en-KY' => 'inglés (Islas Caimán)',
        'en-LC' => 'inglés (Santa Lucía)',
        'en-LR' => 'inglés (Liberia)',
        'en-LS' => 'inglés (Lesoto)',
        'en-MG' => 'inglés (Madagascar)',
        'en-MH' => 'inglés (Islas Marshall)',
        'en-MO' => 'inglés (RAE de Macao [China])',
        'en-MP' => 'inglés (Islas Marianas del Norte)',
        'en-MS' => 'inglés (Montserrat)',
        'en-MT' => 'inglés (Malta)',
        'en-MU' => 'inglés (Mauricio)',
        'en-MW' => 'inglés (Malaui)',
        'en-MY' => 'inglés (Malasia)',
        'en-NA' => 'inglés (Namibia)',
        'en-NF' => 'inglés (Isla Norfolk)',
        'en-NG' => 'inglés (Nigeria)',
        'en-NL' => 'inglés (Países Bajos)',
        'en-NR' => 'inglés (Nauru)',
        'en-NU' => 'inglés (Niue)',
        'en-NZ' => 'inglés (Nueva Zelanda)',
        'en-PG' => 'inglés (Papúa Nueva Guinea)',
        'en-PH' => 'inglés (Filipinas)',
        'en-PK' => 'inglés (Pakistán)',
        'en-PN' => 'inglés (Islas Pitcairn)',
        'en-PR' => 'inglés (Puerto Rico)',
        'en-PW' => 'inglés (Palaos)',
        'en-RW' => 'inglés (Ruanda)',
        'en-SB' => 'inglés (Islas Salomón)',
        'en-SC' => 'inglés (Seychelles)',
        'en-SD' => 'inglés (Sudán)',
        'en-SE' => 'inglés (Suecia)',
        'en-SG' => 'inglés (Singapur)',
        'en-SH' => 'inglés (Santa Elena)',
        'en-SI' => 'inglés (Eslovenia)',
        'en-SL' => 'inglés (Sierra Leona)',
        'en-SS' => 'inglés (Sudán del Sur)',
        'en-SX' => 'inglés (Sint Maarten)',
        'en-SZ' => 'inglés (Suazilandia)',
        'en-TC' => 'inglés (Islas Turcas y Caicos)',
        'en-TK' => 'inglés (Tokelau)',
        'en-TO' => 'inglés (Tonga)',
        'en-TT' => 'inglés (Trinidad y Tobago)',
        'en-TV' => 'inglés (Tuvalu)',
        'en-TZ' => 'inglés (Tanzania)',
        'en-UG' => 'inglés (Uganda)',
        'en-UM' => 'inglés (Islas menores alejadas de EE. UU.)',
        'en-US' => 'inglés (Estados Unidos)',
        'en-US-POSIX' => 'inglés (Estados Unidos, Ordenador)',
        'en-VC' => 'inglés (San Vicente y las Granadinas)',
        'en-VG' => 'inglés (Islas Vírgenes Británicas)',
        'en-VI' => 'inglés (Islas Vírgenes de EE. UU.)',
        'en-VU' => 'inglés (Vanuatu)',
        'en-WS' => 'inglés (Samoa)',
        'en-ZA' => 'inglés (Sudáfrica)',
        'en-ZM' => 'inglés (Zambia)',
        'en-ZW' => 'inglés (Zimbabue)',
        'eo' => 'esperanto',
        'es' => 'español',
        'es-419' => 'español (Latinoamérica)',
        'es-AR' => 'español (Argentina)',
        'es-BO' => 'español (Bolivia)',
        'es-CL' => 'español (Chile)',
        'es-CO' => 'español (Colombia)',
        'es-CR' => 'español (Costa Rica)',
        'es-CU' => 'español (Cuba)',
        'es-DO' => 'español (República Dominicana)',
        'es-EA' => 'español (Ceuta y Melilla)',
        'es-EC' => 'español (Ecuador)',
        'es-ES' => 'español (España)',
        'es-GQ' => 'español (Guinea Ecuatorial)',
        'es-GT' => 'español (Guatemala)',
        'es-HN' => 'español (Honduras)',
        'es-IC' => 'español (Canarias)',
        'es-MX' => 'español (México)',
        'es-NI' => 'español (Nicaragua)',
        'es-PA' => 'español (Panamá)',
        'es-PE' => 'español (Perú)',
        'es-PH' => 'español (Filipinas)',
        'es-PR' => 'español (Puerto Rico)',
        'es-PY' => 'español (Paraguay)',
        'es-SV' => 'español (El Salvador)',
        'es-US' => 'español (Estados Unidos)',
        'es-UY' => 'español (Uruguay)',
        'es-VE' => 'español (Venezuela)',
        'et' => 'estonio',
        'et-EE' => 'estonio (Estonia)',
        'eu' => 'euskera',
        'eu-ES' => 'euskera (España)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Camerún)',
        'fa' => 'persa',
        'fa-AF' => 'persa (Afganistán)',
        'fa-IR' => 'persa (Irán)',
        'ff' => 'fula',
        'ff-CM' => 'fula (Camerún)',
        'ff-GN' => 'fula (Guinea)',
        'ff-MR' => 'fula (Mauritania)',
        'ff-SN' => 'fula (Senegal)',
        'fi' => 'finés',
        'fi-FI' => 'finés (Finlandia)',
        'fil' => 'filipino',
        'fil-PH' => 'filipino (Filipinas)',
        'fo' => 'feroés',
        'fo-DK' => 'feroés (Dinamarca)',
        'fo-FO' => 'feroés (Islas Feroe)',
        'fr' => 'francés',
        'fr-BE' => 'francés (Bélgica)',
        'fr-BF' => 'francés (Burkina Faso)',
        'fr-BI' => 'francés (Burundi)',
        'fr-BJ' => 'francés (Benín)',
        'fr-BL' => 'francés (San Bartolomé)',
        'fr-CA' => 'francés (Canadá)',
        'fr-CD' => 'francés (República Democrática del Congo)',
        'fr-CF' => 'francés (República Centroafricana)',
        'fr-CG' => 'francés (República del Congo)',
        'fr-CH' => 'francés (Suiza)',
        'fr-CI' => 'francés (Costa de Marfil)',
        'fr-CM' => 'francés (Camerún)',
        'fr-DJ' => 'francés (Yibuti)',
        'fr-DZ' => 'francés (Argelia)',
        'fr-FR' => 'francés (Francia)',
        'fr-GA' => 'francés (Gabón)',
        'fr-GF' => 'francés (Guayana Francesa)',
        'fr-GN' => 'francés (Guinea)',
        'fr-GP' => 'francés (Guadalupe)',
        'fr-GQ' => 'francés (Guinea Ecuatorial)',
        'fr-HT' => 'francés (Haití)',
        'fr-KM' => 'francés (Comoras)',
        'fr-LU' => 'francés (Luxemburgo)',
        'fr-MA' => 'francés (Marruecos)',
        'fr-MC' => 'francés (Mónaco)',
        'fr-MF' => 'francés (San Martín)',
        'fr-MG' => 'francés (Madagascar)',
        'fr-ML' => 'francés (Mali)',
        'fr-MQ' => 'francés (Martinica)',
        'fr-MR' => 'francés (Mauritania)',
        'fr-MU' => 'francés (Mauricio)',
        'fr-NC' => 'francés (Nueva Caledonia)',
        'fr-NE' => 'francés (Níger)',
        'fr-PF' => 'francés (Polinesia Francesa)',
        'fr-PM' => 'francés (San Pedro y Miquelón)',
        'fr-RE' => 'francés (Reunión)',
        'fr-RW' => 'francés (Ruanda)',
        'fr-SC' => 'francés (Seychelles)',
        'fr-SN' => 'francés (Senegal)',
        'fr-SY' => 'francés (Siria)',
        'fr-TD' => 'francés (Chad)',
        'fr-TG' => 'francés (Togo)',
        'fr-TN' => 'francés (Túnez)',
        'fr-VU' => 'francés (Vanuatu)',
        'fr-WF' => 'francés (Wallis y Futuna)',
        'fr-YT' => 'francés (Mayotte)',
        'fur' => 'friulano',
        'fur-IT' => 'friulano (Italia)',
        'fy' => 'frisón occidental',
        'fy-NL' => 'frisón occidental (Países Bajos)',
        'ga' => 'irlandés',
        'ga-IE' => 'irlandés (Irlanda)',
        'gd' => 'gaélico escocés',
        'gd-GB' => 'gaélico escocés (Reino Unido)',
        'gl' => 'gallego',
        'gl-ES' => 'gallego (España)',
        'gsw' => 'alemán suizo',
        'gsw-CH' => 'alemán suizo (Suiza)',
        'gsw-FR' => 'alemán suizo (Francia)',
        'gsw-LI' => 'alemán suizo (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (India)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenia)',
        'gv' => 'manés',
        'gv-IM' => 'manés (Isla de Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Níger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiano',
        'haw-US' => 'hawaiano (Estados Unidos)',
        'he' => 'hebreo',
        'he-IL' => 'hebreo (Israel)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (India)',
        'hr' => 'croata',
        'hr-BA' => 'croata (Bosnia-Herzegovina)',
        'hr-HR' => 'croata (Croacia)',
        'hsb' => 'alto sorbio',
        'hsb-DE' => 'alto sorbio (Alemania)',
        'hu' => 'húngaro',
        'hu-HU' => 'húngaro (Hungría)',
        'hy' => 'armenio',
        'hy-AM' => 'armenio (Armenia)',
        'id' => 'indonesio',
        'id-ID' => 'indonesio (Indonesia)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigeria)',
        'ii' => 'yi de Sichuán',
        'ii-CN' => 'yi de Sichuán (China)',
        'is' => 'islandés',
        'is-IS' => 'islandés (Islandia)',
        'it' => 'italiano',
        'it-CH' => 'italiano (Suiza)',
        'it-IT' => 'italiano (Italia)',
        'it-SM' => 'italiano (San Marino)',
        'ja' => 'japonés',
        'ja-JP' => 'japonés (Japón)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Camerún)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzania)',
        'ka' => 'georgiano',
        'ka-GE' => 'georgiano (Georgia)',
        'kab' => 'cabila',
        'kab-DZ' => 'cabila (Argelia)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenia)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'criollo caboverdiano',
        'kea-CV' => 'criollo caboverdiano (Cabo Verde)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenia)',
        'kk' => 'kazajo',
        'kk-KZ' => 'kazajo (Kazajistán)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Camerún)',
        'kl' => 'groenlandés',
        'kl-GL' => 'groenlandés (Groenlandia)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenia)',
        'km' => 'jemer',
        'km-KH' => 'jemer (Camboya)',
        'kn' => 'canarés',
        'kn-IN' => 'canarés (India)',
        'ko' => 'coreano',
        'ko-KP' => 'coreano (Corea del Norte)',
        'ko-KR' => 'coreano (Corea del Sur)',
        'kok' => 'konkaní',
        'kok-IN' => 'konkaní (India)',
        'ks' => 'cachemiro',
        'ks-IN' => 'cachemiro (India)',
        'ksb' => 'shambala',
        'ksb-TZ' => 'shambala (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Camerún)',
        'ksh' => 'kölsch',
        'ksh-DE' => 'kölsch (Alemania)',
        'kw' => 'córnico',
        'kw-GB' => 'córnico (Reino Unido)',
        'ky' => 'kirguís',
        'ky-KG' => 'kirguís (Kirguistán)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'luxemburgués',
        'lb-LU' => 'luxemburgués (Luxemburgo)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (Estados Unidos)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (República Democrática del Congo)',
        'ln-CF' => 'lingala (República Centroafricana)',
        'ln-CG' => 'lingala (República del Congo)',
        'lo' => 'laosiano',
        'lo-LA' => 'laosiano (Laos)',
        'lrc' => 'lorí septentrional',
        'lrc-IQ' => 'lorí septentrional (Irak)',
        'lrc-IR' => 'lorí septentrional (Irán)',
        'lt' => 'lituano',
        'lt-LT' => 'lituano (Lituania)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (República Democrática del Congo)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenia)',
        'luy' => 'luyia',
        'luy-KE' => 'luyia (Kenia)',
        'lv' => 'letón',
        'lv-LV' => 'letón (Letonia)',
        'mas' => 'masái',
        'mas-KE' => 'masái (Kenia)',
        'mas-TZ' => 'masái (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenia)',
        'mfe' => 'criollo mauriciano',
        'mfe-MU' => 'criollo mauriciano (Mauricio)',
        'mg' => 'malgache',
        'mg-MG' => 'malgache (Madagascar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mozambique)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Camerún)',
        'mk' => 'macedonio',
        'mk-MK' => 'macedonio (Macedonia)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (India)',
        'mn' => 'mongol',
        'mn-MN' => 'mongol (Mongolia)',
        'mr' => 'maratí',
        'mr-IN' => 'maratí (India)',
        'ms' => 'malayo',
        'ms-BN' => 'malayo (Brunéi)',
        'ms-MY' => 'malayo (Malasia)',
        'ms-SG' => 'malayo (Singapur)',
        'mt' => 'maltés',
        'mt-MT' => 'maltés (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Camerún)',
        'my' => 'birmano',
        'my-MM' => 'birmano (Myanmar [Birmania])',
        'mzn' => 'mazandaraní',
        'mzn-IR' => 'mazandaraní (Irán)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'noruego bokmal',
        'nb-NO' => 'noruego bokmal (Noruega)',
        'nb-SJ' => 'noruego bokmal (Svalbard y Jan Mayen)',
        'nd' => 'ndebele septentrional',
        'nd-ZW' => 'ndebele septentrional (Zimbabue)',
        'ne' => 'nepalí',
        'ne-IN' => 'nepalí (India)',
        'ne-NP' => 'nepalí (Nepal)',
        'nl' => 'neerlandés',
        'nl-AW' => 'neerlandés (Aruba)',
        'nl-BE' => 'neerlandés (Bélgica)',
        'nl-BQ' => 'neerlandés (Caribe neerlandés)',
        'nl-CW' => 'neerlandés (Curazao)',
        'nl-NL' => 'neerlandés (Países Bajos)',
        'nl-SR' => 'neerlandés (Surinam)',
        'nl-SX' => 'neerlandés (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Camerún)',
        'nn' => 'noruego nynorsk',
        'nn-NO' => 'noruego nynorsk (Noruega)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Camerún)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sudán del Sur)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopía)',
        'om-KE' => 'oromo (Kenia)',
        'or' => 'oriya',
        'or-IN' => 'oriya (India)',
        'os' => 'osético',
        'os-GE' => 'osético (Georgia)',
        'os-RU' => 'osético (Rusia)',
        'pa' => 'panyabí',
        'pa-Arab' => 'panyabí (árabe)',
        'pa-Arab-PK' => 'panyabí (árabe, Pakistán)',
        'pa-Guru' => 'panyabí (gurmuji)',
        'pa-Guru-IN' => 'panyabí (gurmuji, India)',
        'pl' => 'polaco',
        'pl-PL' => 'polaco (Polonia)',
        'ps' => 'pastún',
        'ps-AF' => 'pastún (Afganistán)',
        'pt' => 'portugués',
        'pt-AO' => 'portugués (Angola)',
        'pt-BR' => 'portugués (Brasil)',
        'pt-CV' => 'portugués (Cabo Verde)',
        'pt-GW' => 'portugués (Guinea-Bisáu)',
        'pt-MO' => 'portugués (RAE de Macao [China])',
        'pt-MZ' => 'portugués (Mozambique)',
        'pt-PT' => 'portugués (Portugal)',
        'pt-ST' => 'portugués (Santo Tomé y Príncipe)',
        'pt-TL' => 'portugués (Timor Oriental)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Perú)',
        'rm' => 'retorrománico',
        'rm-CH' => 'retorrománico (Suiza)',
        'rn' => 'kiroundi',
        'rn-BI' => 'kiroundi (Burundi)',
        'ro' => 'rumano',
        'ro-MD' => 'rumano (Moldavia)',
        'ro-RO' => 'rumano (Rumanía)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'ruso',
        'ru-BY' => 'ruso (Bielorrusia)',
        'ru-KG' => 'ruso (Kirguistán)',
        'ru-KZ' => 'ruso (Kazajistán)',
        'ru-MD' => 'ruso (Moldavia)',
        'ru-RU' => 'ruso (Rusia)',
        'ru-UA' => 'ruso (Ucrania)',
        'rw' => 'kinyarwanda',
        'rw-RW' => 'kinyarwanda (Ruanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'sakha',
        'sah-RU' => 'sakha (Rusia)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenia)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'sami septentrional',
        'se-FI' => 'sami septentrional (Finlandia)',
        'se-NO' => 'sami septentrional (Noruega)',
        'se-SE' => 'sami septentrional (Suecia)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambique)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (República Centroafricana)',
        'shi' => 'tashelhit',
        'shi-Latn' => 'tashelhit (latín)',
        'shi-Latn-MA' => 'tashelhit (latín, Marruecos)',
        'shi-Tfng' => 'tashelhit (tifinagh)',
        'shi-Tfng-MA' => 'tashelhit (tifinagh, Marruecos)',
        'si' => 'cingalés',
        'si-LK' => 'cingalés (Sri Lanka)',
        'sk' => 'eslovaco',
        'sk-SK' => 'eslovaco (Eslovaquia)',
        'sl' => 'esloveno',
        'sl-SI' => 'esloveno (Eslovenia)',
        'smn' => 'sami inari',
        'smn-FI' => 'sami inari (Finlandia)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabue)',
        'so' => 'somalí',
        'so-DJ' => 'somalí (Yibuti)',
        'so-ET' => 'somalí (Etiopía)',
        'so-KE' => 'somalí (Kenia)',
        'so-SO' => 'somalí (Somalia)',
        'sq' => 'albanés',
        'sq-AL' => 'albanés (Albania)',
        'sq-MK' => 'albanés (Macedonia)',
        'sq-XK' => 'albanés (Kosovo)',
        'sr' => 'serbio',
        'sr-Cyrl' => 'serbio (cirílico)',
        'sr-Cyrl-BA' => 'serbio (cirílico, Bosnia-Herzegovina)',
        'sr-Cyrl-ME' => 'serbio (cirílico, Montenegro)',
        'sr-Cyrl-RS' => 'serbio (cirílico, Serbia)',
        'sr-Cyrl-XK' => 'serbio (cirílico, Kosovo)',
        'sr-Latn' => 'serbio (latín)',
        'sr-Latn-BA' => 'serbio (latín, Bosnia-Herzegovina)',
        'sr-Latn-ME' => 'serbio (latín, Montenegro)',
        'sr-Latn-RS' => 'serbio (latín, Serbia)',
        'sr-Latn-XK' => 'serbio (latín, Kosovo)',
        'sv' => 'sueco',
        'sv-AX' => 'sueco (Islas Åland)',
        'sv-FI' => 'sueco (Finlandia)',
        'sv-SE' => 'sueco (Suecia)',
        'sw' => 'suajili',
        'sw-CD' => 'suajili (República Democrática del Congo)',
        'sw-KE' => 'suajili (Kenia)',
        'sw-TZ' => 'suajili (Tanzania)',
        'sw-UG' => 'suajili (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (India)',
        'ta-LK' => 'tamil (Sri Lanka)',
        'ta-MY' => 'tamil (Malasia)',
        'ta-SG' => 'tamil (Singapur)',
        'te' => 'telugu',
        'te-IN' => 'telugu (India)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenia)',
        'teo-UG' => 'teso (Uganda)',
        'th' => 'tailandés',
        'th-TH' => 'tailandés (Tailandia)',
        'ti' => 'tigriña',
        'ti-ER' => 'tigriña (Eritrea)',
        'ti-ET' => 'tigriña (Etiopía)',
        'to' => 'tongano',
        'to-TO' => 'tongano (Tonga)',
        'tr' => 'turco',
        'tr-CY' => 'turco (Chipre)',
        'tr-TR' => 'turco (Turquía)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Níger)',
        'tzm' => 'tamazight del Marruecos Central',
        'tzm-MA' => 'tamazight del Marruecos Central (Marruecos)',
        'ug' => 'uigur',
        'ug-CN' => 'uigur (China)',
        'uk' => 'ucraniano',
        'uk-UA' => 'ucraniano (Ucrania)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (India)',
        'ur-PK' => 'urdu (Pakistán)',
        'uz' => 'uzbeko',
        'uz-Arab' => 'uzbeko (árabe)',
        'uz-Arab-AF' => 'uzbeko (árabe, Afganistán)',
        'uz-Cyrl' => 'uzbeko (cirílico)',
        'uz-Cyrl-UZ' => 'uzbeko (cirílico, Uzbekistán)',
        'uz-Latn' => 'uzbeko (latín)',
        'uz-Latn-UZ' => 'uzbeko (latín, Uzbekistán)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latín)',
        'vai-Latn-LR' => 'vai (latín, Liberia)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Liberia)',
        'vi' => 'vietnamita',
        'vi-VN' => 'vietnamita (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Suiza)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Camerún)',
        'yi' => 'yídish',
        'yi-001' => 'yídish (Mundo)',
        'yo' => 'yoruba',
        'yo-BJ' => 'yoruba (Benín)',
        'yo-NG' => 'yoruba (Nigeria)',
        'yue' => 'cantonés',
        'yue-HK' => 'cantonés (RAE de Hong Kong [China])',
        'zgh' => 'tamazight estándar marroquí',
        'zgh-MA' => 'tamazight estándar marroquí (Marruecos)',
        'zh' => 'chino',
        'zh-Hans' => 'chino (simplificado)',
        'zh-Hans-CN' => 'chino (simplificado, China)',
        'zh-Hans-HK' => 'chino (simplificado, RAE de Hong Kong [China])',
        'zh-Hans-MO' => 'chino (simplificado, RAE de Macao [China])',
        'zh-Hans-SG' => 'chino (simplificado, Singapur)',
        'zh-Hant' => 'chino (tradicional)',
        'zh-Hant-HK' => 'chino (tradicional, RAE de Hong Kong [China])',
        'zh-Hant-MO' => 'chino (tradicional, RAE de Macao [China])',
        'zh-Hant-TW' => 'chino (tradicional, Taiwán)',
        'zu' => 'zulú',
        'zu-ZA' => 'zulú (Sudáfrica)',
    ],
];
